/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;

public interface Trie<V> {
    public boolean put(String var1, V var2);

    public boolean put(V var1);

    public V remove(String var1);

    public V get(String var1);

    public V get(String var1, int var2, int var3);

    public V get(ByteBuffer var1);

    public V get(ByteBuffer var1, int var2, int var3);

    public V getBest(String var1);

    public V getBest(String var1, int var2, int var3);

    public V getBest(byte[] var1, int var2, int var3);

    default public V getBest(byte[] byArray) {
        return this.getBest(byArray, 0, byArray.length);
    }

    public V getBest(ByteBuffer var1, int var2, int var3);

    default public V getBest(ByteBuffer byteBuffer) {
        return this.getBest(byteBuffer, 0, byteBuffer.remaining());
    }

    public Set<String> keySet();

    public boolean isFull();

    public boolean isCaseInsensitive();

    public void clear();

    public static <T> Trie<T> empty(final boolean bl) {
        return new Trie<T>(){

            @Override
            public boolean put(String string, Object object) {
                return false;
            }

            @Override
            public boolean put(Object object) {
                return false;
            }

            @Override
            public T remove(String string) {
                return null;
            }

            @Override
            public T get(String string) {
                return null;
            }

            @Override
            public T get(String string, int n, int n2) {
                return null;
            }

            @Override
            public T get(ByteBuffer byteBuffer) {
                return null;
            }

            @Override
            public T get(ByteBuffer byteBuffer, int n, int n2) {
                return null;
            }

            @Override
            public T getBest(String string) {
                return null;
            }

            @Override
            public T getBest(String string, int n, int n2) {
                return null;
            }

            @Override
            public T getBest(byte[] byArray, int n, int n2) {
                return null;
            }

            @Override
            public T getBest(ByteBuffer byteBuffer, int n, int n2) {
                return null;
            }

            @Override
            public Set<String> keySet() {
                return Collections.emptySet();
            }

            @Override
            public boolean isFull() {
                return true;
            }

            @Override
            public boolean isCaseInsensitive() {
                return bl;
            }

            @Override
            public void clear() {
            }
        };
    }
}

