/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;

@Deprecated
public class ReadLineInputStream
extends BufferedInputStream {
    boolean _seenCRLF;
    boolean _skipLF;
    private EnumSet<Termination> _lineTerminations = EnumSet.noneOf(Termination.class);

    public EnumSet<Termination> getLineTerminations() {
        return this._lineTerminations;
    }

    public ReadLineInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public ReadLineInputStream(InputStream inputStream, int n) {
        super(inputStream, n);
    }

    public String readLine() throws IOException {
        this.mark(this.buf.length);
        while (true) {
            int n = super.read();
            if (this.markpos < 0) {
                throw new IOException("Buffer size exceeded: no line terminator");
            }
            if (this._skipLF && n != 10) {
                this._lineTerminations.add(Termination.CR);
            }
            if (n == -1) {
                int n2 = this.markpos;
                this.markpos = -1;
                if (this.pos > n2) {
                    this._lineTerminations.add(Termination.EOF);
                    return new String(this.buf, n2, this.pos - n2, StandardCharsets.UTF_8);
                }
                return null;
            }
            if (n == 13) {
                int n3 = this.pos;
                if (this._seenCRLF && this.pos < this.count) {
                    if (this.buf[this.pos] == 10) {
                        this._lineTerminations.add(Termination.CRLF);
                        ++this.pos;
                    } else {
                        this._lineTerminations.add(Termination.CR);
                    }
                } else {
                    this._skipLF = true;
                }
                int n4 = this.markpos;
                this.markpos = -1;
                return new String(this.buf, n4, n3 - n4 - 1, StandardCharsets.UTF_8);
            }
            if (n != 10) continue;
            if (!this._skipLF) break;
            this._skipLF = false;
            this._seenCRLF = true;
            ++this.markpos;
            this._lineTerminations.add(Termination.CRLF);
        }
        int n = this.markpos;
        this.markpos = -1;
        this._lineTerminations.add(Termination.LF);
        return new String(this.buf, n, this.pos - n - 1, StandardCharsets.UTF_8);
    }

    @Override
    public synchronized int read() throws IOException {
        int n = super.read();
        if (this._skipLF) {
            this._skipLF = false;
            if (this._seenCRLF && n == 10) {
                n = super.read();
            }
        }
        return n;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (this._skipLF && n2 > 0) {
            this._skipLF = false;
            if (this._seenCRLF) {
                int n3 = super.read();
                if (n3 == -1) {
                    return -1;
                }
                if (n3 != 10) {
                    byArray[n] = (byte)(0xFF & n3);
                    return 1 + super.read(byArray, n + 1, n2 - 1);
                }
            }
        }
        return super.read(byArray, n, n2);
    }

    public static enum Termination {
        CRLF,
        LF,
        CR,
        EOF;

    }
}

