/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.util.log.Log;

public interface Promise<C> {
    default public void succeeded(C c) {
    }

    default public void failed(Throwable throwable) {
    }

    public static <T> Promise<T> from(final CompletableFuture<? super T> completableFuture) {
        if (completableFuture instanceof Promise) {
            return (Promise)((Object)completableFuture);
        }
        return new Promise<T>(){

            @Override
            public void succeeded(T t) {
                completableFuture.complete(t);
            }

            @Override
            public void failed(Throwable throwable) {
                completableFuture.completeExceptionally(throwable);
            }
        };
    }

    public static class Wrapper<W>
    implements Promise<W> {
        private final Promise<W> promise;

        public Wrapper(Promise<W> promise) {
            this.promise = Objects.requireNonNull(promise);
        }

        @Override
        public void succeeded(W w) {
            this.promise.succeeded(w);
        }

        @Override
        public void failed(Throwable throwable) {
            this.promise.failed(throwable);
        }

        public Promise<W> getPromise() {
            return this.promise;
        }

        public Promise<W> unwrap() {
            Promise<W> promise = this.promise;
            while (promise instanceof Wrapper) {
                promise = ((Wrapper)promise).unwrap();
            }
            return promise;
        }
    }

    public static class Completable<S>
    extends CompletableFuture<S>
    implements Promise<S> {
        @Override
        public void succeeded(S s) {
            this.complete(s);
        }

        @Override
        public void failed(Throwable throwable) {
            this.completeExceptionally(throwable);
        }
    }

    public static class Adapter<U>
    implements Promise<U> {
        @Override
        public void failed(Throwable throwable) {
            Log.getLogger(this.getClass()).warn(throwable);
        }
    }
}

