/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

class ModuleLocation
implements Function<Class<?>, URI> {
    private static final Logger LOG = Log.getLogger(ModuleLocation.class);
    private final Class<?> classModule;
    private final MethodHandle handleGetModule;
    private final MethodHandle handleGetLayer;
    private final MethodHandle handleConfiguration;
    private final MethodHandle handleGetName;
    private final MethodHandle handleOptionalResolvedModule;
    private final MethodHandle handleReference;
    private final MethodHandle handleLocation;

    public ModuleLocation() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try {
            this.classModule = classLoader.loadClass("java.lang.Module");
            this.handleGetModule = lookup.findVirtual(Class.class, "getModule", MethodType.methodType(this.classModule));
            Class<?> clazz = classLoader.loadClass("java.lang.ModuleLayer");
            this.handleGetLayer = lookup.findVirtual(this.classModule, "getLayer", MethodType.methodType(clazz));
            Class<?> clazz2 = classLoader.loadClass("java.lang.module.Configuration");
            this.handleConfiguration = lookup.findVirtual(clazz, "configuration", MethodType.methodType(clazz2));
            this.handleGetName = lookup.findVirtual(this.classModule, "getName", MethodType.methodType(String.class));
            Method method = clazz2.getMethod("findModule", String.class);
            this.handleOptionalResolvedModule = lookup.findVirtual(clazz2, "findModule", MethodType.methodType(method.getReturnType(), String.class));
            Class<?> clazz3 = classLoader.loadClass("java.lang.module.ResolvedModule");
            Class<?> clazz4 = classLoader.loadClass("java.lang.module.ModuleReference");
            this.handleReference = lookup.findVirtual(clazz3, "reference", MethodType.methodType(clazz4));
            Method method2 = clazz4.getMethod("location", new Class[0]);
            this.handleLocation = lookup.findVirtual(clazz4, "location", MethodType.methodType(method2.getReturnType()));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new UnsupportedOperationException("Not supported on this runtime", reflectiveOperationException);
        }
    }

    @Override
    public URI apply(Class<?> clazz) {
        block8: {
            try {
                Object object = this.handleGetModule.invoke(clazz);
                if (object == null) {
                    return null;
                }
                Object object2 = this.handleGetLayer.invoke(object);
                if (object2 == null) {
                    return null;
                }
                Object object3 = this.handleConfiguration.invoke(object2);
                if (object3 == null) {
                    return null;
                }
                String string = this.handleGetName.invoke(object);
                if (string == null) {
                    return null;
                }
                Optional optional = this.handleOptionalResolvedModule.invoke(object3, string);
                if (!optional.isPresent()) {
                    return null;
                }
                Object t = optional.get();
                Object object4 = this.handleReference.invoke(t);
                Optional optional2 = this.handleLocation.invoke(object4);
                if (optional2 != null || optional2.isPresent()) {
                    return (URI)optional2.get();
                }
            }
            catch (Throwable throwable) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.ignore(throwable);
            }
        }
        return null;
    }
}

