/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Fields
implements Iterable<Field> {
    private final boolean caseSensitive;
    private final Map<String, Field> fields;

    public Fields() {
        this(false);
    }

    public Fields(boolean bl) {
        this.caseSensitive = bl;
        this.fields = new LinkedHashMap<String, Field>();
    }

    public Fields(Fields fields, boolean bl) {
        this.caseSensitive = fields.caseSensitive;
        LinkedHashMap<String, Field> linkedHashMap = new LinkedHashMap<String, Field>();
        linkedHashMap.putAll(fields.fields);
        this.fields = bl ? Collections.unmodifiableMap(linkedHashMap) : linkedHashMap;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Fields fields = (Fields)object;
        if (this.getSize() != fields.getSize()) {
            return false;
        }
        if (this.caseSensitive != fields.caseSensitive) {
            return false;
        }
        for (Map.Entry<String, Field> entry : this.fields.entrySet()) {
            String string = entry.getKey();
            Field field = entry.getValue();
            if (field.equals(fields.get(string), this.caseSensitive)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public Set<String> getNames() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Field field : this.fields.values()) {
            linkedHashSet.add(field.getName());
        }
        return linkedHashSet;
    }

    private String normalizeName(String string) {
        return this.caseSensitive ? string : string.toLowerCase(Locale.ENGLISH);
    }

    public Field get(String string) {
        return this.fields.get(this.normalizeName(string));
    }

    public void put(String string, String string2) {
        Field field = new Field(string, string2);
        this.fields.put(this.normalizeName(string), field);
    }

    public void put(Field field) {
        if (field != null) {
            this.fields.put(this.normalizeName(field.getName()), field);
        }
    }

    public void add(String string, String string2) {
        String string3 = this.normalizeName(string);
        Field field = this.fields.get(string3);
        if (field == null) {
            field = new Field(string, string2);
            this.fields.put(string3, field);
        } else {
            field = new Field(field.getName(), (List)field.getValues(), new String[]{string2});
            this.fields.put(string3, field);
        }
    }

    public Field remove(String string) {
        return this.fields.remove(this.normalizeName(string));
    }

    public void clear() {
        this.fields.clear();
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public int getSize() {
        return this.fields.size();
    }

    @Override
    public Iterator<Field> iterator() {
        return this.fields.values().iterator();
    }

    public String toString() {
        return this.fields.toString();
    }

    public static class Field {
        private final String name;
        private final List<String> values;

        public Field(String string, String string2) {
            this(string, Collections.singletonList(string2), new String[0]);
        }

        private Field(String string, List<String> list, String ... stringArray) {
            this.name = string;
            ArrayList<String> arrayList = new ArrayList<String>(list.size() + stringArray.length);
            arrayList.addAll(list);
            arrayList.addAll(Arrays.asList(stringArray));
            this.values = Collections.unmodifiableList(arrayList);
        }

        public boolean equals(Field field, boolean bl) {
            if (this == field) {
                return true;
            }
            if (field == null) {
                return false;
            }
            if (bl) {
                return this.equals(field);
            }
            return this.name.equalsIgnoreCase(field.name) && this.values.equals(field.values);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Field field = (Field)object;
            return this.name.equals(field.name) && this.values.equals(field.values);
        }

        public int hashCode() {
            int n = this.name.hashCode();
            n = 31 * n + this.values.hashCode();
            return n;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.values.get(0);
        }

        public Integer getValueAsInt() {
            String string = this.getValue();
            return string == null ? null : Integer.valueOf(string);
        }

        public List<String> getValues() {
            return this.values;
        }

        public boolean hasMultipleValues() {
            return this.values.size() > 1;
        }

        public String toString() {
            return String.format("%s=%s", this.name, this.values);
        }
    }
}

