/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.jetty.util.thread.Invocable;

public interface Callback
extends Invocable {
    public static final Callback NOOP = new Callback(){

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }
    };

    default public void succeeded() {
    }

    default public void failed(Throwable throwable) {
    }

    public static Callback from(CompletableFuture<?> completableFuture) {
        return Callback.from(completableFuture, Invocable.InvocationType.NON_BLOCKING);
    }

    public static Callback from(final CompletableFuture<?> completableFuture, final Invocable.InvocationType invocationType) {
        if (completableFuture instanceof Callback) {
            return (Callback)((Object)completableFuture);
        }
        return new Callback(){

            @Override
            public void succeeded() {
                completableFuture.complete(null);
            }

            @Override
            public void failed(Throwable throwable) {
                completableFuture.completeExceptionally(throwable);
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return invocationType;
            }
        };
    }

    public static Callback from(Runnable runnable, Consumer<Throwable> consumer) {
        return Callback.from(Invocable.InvocationType.BLOCKING, runnable, consumer);
    }

    public static Callback from(final Invocable.InvocationType invocationType, final Runnable runnable, final Consumer<Throwable> consumer) {
        return new Callback(){

            @Override
            public void succeeded() {
                runnable.run();
            }

            @Override
            public void failed(Throwable throwable) {
                consumer.accept(throwable);
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return invocationType;
            }
        };
    }

    public static Callback from(final Runnable runnable) {
        return new Completing(){

            @Override
            public void completed() {
                runnable.run();
            }
        };
    }

    public static Callback from(Callback callback, final Runnable runnable) {
        return new Nested(callback){

            @Override
            public void completed() {
                runnable.run();
            }
        };
    }

    public static Callback from(final Runnable runnable, final Callback callback) {
        return new Callback(){

            @Override
            public void succeeded() {
                try {
                    runnable.run();
                    callback.succeeded();
                }
                catch (Throwable throwable) {
                    callback.failed(throwable);
                }
            }

            @Override
            public void failed(Throwable throwable) {
                try {
                    runnable.run();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                callback.failed(throwable);
            }
        };
    }

    public static Callback combine(final Callback callback, final Callback callback2) {
        if (callback == null || callback == callback2) {
            return callback2;
        }
        if (callback2 == null) {
            return callback;
        }
        return new Callback(){

            @Override
            public void succeeded() {
                try {
                    callback.succeeded();
                }
                finally {
                    callback2.succeeded();
                }
            }

            @Override
            public void failed(Throwable throwable) {
                try {
                    callback.failed(throwable);
                }
                catch (Throwable throwable2) {
                    if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                finally {
                    callback2.failed(throwable);
                }
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return Invocable.combine(Invocable.getInvocationType(callback), Invocable.getInvocationType(callback2));
            }
        };
    }

    public static class Completable
    extends CompletableFuture<Void>
    implements Callback {
        private final Invocable.InvocationType invocation;

        public Completable() {
            this(Invocable.InvocationType.NON_BLOCKING);
        }

        public Completable(Invocable.InvocationType invocationType) {
            this.invocation = invocationType;
        }

        @Override
        public void succeeded() {
            this.complete(null);
        }

        @Override
        public void failed(Throwable throwable) {
            this.completeExceptionally(throwable);
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return this.invocation;
        }
    }

    public static class Nested
    extends Completing {
        private final Callback callback;

        public Nested(Callback callback) {
            this.callback = callback;
        }

        public Nested(Nested nested) {
            this.callback = nested.callback;
        }

        public Callback getCallback() {
            return this.callback;
        }

        @Override
        public void succeeded() {
            try {
                this.callback.succeeded();
            }
            finally {
                this.completed();
            }
        }

        @Override
        public void failed(Throwable throwable) {
            try {
                this.callback.failed(throwable);
            }
            finally {
                this.completed();
            }
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return this.callback.getInvocationType();
        }
    }

    public static class Completing
    implements Callback {
        @Override
        public void succeeded() {
            this.completed();
        }

        @Override
        public void failed(Throwable throwable) {
            this.completed();
        }

        public void completed() {
        }
    }
}

