/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.ssl;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SslClientConnectionFactory
implements ClientConnectionFactory {
    public static final String SSL_CONTEXT_FACTORY_CONTEXT_KEY = "ssl.context.factory";
    public static final String SSL_PEER_HOST_CONTEXT_KEY = "ssl.peer.host";
    public static final String SSL_PEER_PORT_CONTEXT_KEY = "ssl.peer.port";
    public static final String SSL_ENGINE_CONTEXT_KEY = "ssl.engine";
    private final SslContextFactory sslContextFactory;
    private final ByteBufferPool byteBufferPool;
    private final Executor executor;
    private final ClientConnectionFactory connectionFactory;
    private boolean _directBuffersForEncryption = true;
    private boolean _directBuffersForDecryption = true;
    private boolean _requireCloseMessage;

    public SslClientConnectionFactory(SslContextFactory sslContextFactory, ByteBufferPool byteBufferPool, Executor executor, ClientConnectionFactory clientConnectionFactory) {
        this.sslContextFactory = Objects.requireNonNull(sslContextFactory, "Missing SslContextFactory");
        this.byteBufferPool = byteBufferPool;
        this.executor = executor;
        this.connectionFactory = clientConnectionFactory;
    }

    public void setDirectBuffersForEncryption(boolean bl) {
        this._directBuffersForEncryption = bl;
    }

    public void setDirectBuffersForDecryption(boolean bl) {
        this._directBuffersForDecryption = bl;
    }

    public boolean isDirectBuffersForDecryption() {
        return this._directBuffersForDecryption;
    }

    public boolean isDirectBuffersForEncryption() {
        return this._directBuffersForEncryption;
    }

    @Deprecated
    public boolean isAllowMissingCloseMessage() {
        return !this.isRequireCloseMessage();
    }

    @Deprecated
    public void setAllowMissingCloseMessage(boolean bl) {
        this.setRequireCloseMessage(!bl);
    }

    public boolean isRequireCloseMessage() {
        return this._requireCloseMessage;
    }

    public void setRequireCloseMessage(boolean bl) {
        this._requireCloseMessage = bl;
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> map) throws IOException {
        String string = (String)map.get(SSL_PEER_HOST_CONTEXT_KEY);
        int n = (Integer)map.get(SSL_PEER_PORT_CONTEXT_KEY);
        SSLEngine sSLEngine = this.sslContextFactory instanceof SslEngineFactory ? ((SslEngineFactory)((Object)this.sslContextFactory)).newSslEngine(string, n, map) : this.sslContextFactory.newSSLEngine(string, n);
        sSLEngine.setUseClientMode(true);
        map.put(SSL_ENGINE_CONTEXT_KEY, sSLEngine);
        SslConnection sslConnection = this.newSslConnection(this.byteBufferPool, this.executor, endPoint, sSLEngine);
        SslConnection.DecryptedEndPoint decryptedEndPoint = sslConnection.getDecryptedEndPoint();
        decryptedEndPoint.setConnection(this.connectionFactory.newConnection(decryptedEndPoint, map));
        sslConnection.addHandshakeListener(new HTTPSHandshakeListener(map));
        this.customize(sslConnection, map);
        return sslConnection;
    }

    protected SslConnection newSslConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, SSLEngine sSLEngine) {
        return new SslConnection(byteBufferPool, executor, endPoint, sSLEngine, this.isDirectBuffersForEncryption(), this.isDirectBuffersForDecryption());
    }

    @Override
    public Connection customize(Connection connection, Map<String, Object> map) {
        if (connection instanceof SslConnection) {
            SslConnection sslConnection = (SslConnection)connection;
            sslConnection.setRenegotiationAllowed(this.sslContextFactory.isRenegotiationAllowed());
            sslConnection.setRenegotiationLimit(this.sslContextFactory.getRenegotiationLimit());
            sslConnection.setRequireCloseMessage(this.isRequireCloseMessage());
            ContainerLifeCycle containerLifeCycle = (ContainerLifeCycle)map.get("client.connector");
            containerLifeCycle.getBeans(SslHandshakeListener.class).forEach(sslConnection::addHandshakeListener);
        }
        return ClientConnectionFactory.super.customize(connection, map);
    }

    private class HTTPSHandshakeListener
    implements SslHandshakeListener {
        private final Map<String, Object> context;

        private HTTPSHandshakeListener(Map<String, Object> map) {
            this.context = map;
        }

        @Override
        public void handshakeSucceeded(SslHandshakeListener.Event event) throws SSLException {
            HostnameVerifier hostnameVerifier = SslClientConnectionFactory.this.sslContextFactory.getHostnameVerifier();
            if (hostnameVerifier != null) {
                String string = (String)this.context.get(SslClientConnectionFactory.SSL_PEER_HOST_CONTEXT_KEY);
                try {
                    if (!hostnameVerifier.verify(string, event.getSSLEngine().getSession())) {
                        throw new SSLPeerUnverifiedException("Host name verification failed for host: " + string);
                    }
                }
                catch (SSLException sSLException) {
                    throw sSLException;
                }
                catch (Throwable throwable) {
                    throw (SSLException)new SSLPeerUnverifiedException("Host name verification failed for host: " + string).initCause(throwable);
                }
            }
        }
    }

    public static interface SslEngineFactory {
        public SSLEngine newSslEngine(String var1, int var2, Map<String, Object> var3);
    }
}

