/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;

public abstract class AbstractConnection
implements Connection {
    private static final Logger LOG = Log.getLogger(AbstractConnection.class);
    private final List<Connection.Listener> _listeners = new CopyOnWriteArrayList<Connection.Listener>();
    private final long _created = System.currentTimeMillis();
    private final EndPoint _endPoint;
    private final Executor _executor;
    private final Callback _readCallback;
    private int _inputBufferSize = 2048;

    protected AbstractConnection(EndPoint endPoint, Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("Executor must not be null!");
        }
        this._endPoint = endPoint;
        this._executor = executor;
        this._readCallback = new ReadCallback();
    }

    @Override
    public void addListener(Connection.Listener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeListener(Connection.Listener listener) {
        this._listeners.remove(listener);
    }

    public int getInputBufferSize() {
        return this._inputBufferSize;
    }

    public void setInputBufferSize(int n) {
        this._inputBufferSize = n;
    }

    protected Executor getExecutor() {
        return this._executor;
    }

    protected void failedCallback(Callback callback, Throwable throwable) {
        Runnable runnable = () -> {
            try {
                callback.failed(throwable);
            }
            catch (Exception exception) {
                LOG.warn(exception);
            }
        };
        switch (Invocable.getInvocationType(callback)) {
            case BLOCKING: {
                try {
                    this.getExecutor().execute(runnable);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    LOG.debug(rejectedExecutionException);
                    callback.failed(throwable);
                }
                break;
            }
            case NON_BLOCKING: {
                runnable.run();
                break;
            }
            case EITHER: {
                Invocable.invokeNonBlocking(runnable);
            }
        }
    }

    public void fillInterested() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("fillInterested {}", this);
        }
        this.getEndPoint().fillInterested(this._readCallback);
    }

    public void tryFillInterested() {
        this.tryFillInterested(this._readCallback);
    }

    public void tryFillInterested(Callback callback) {
        this.getEndPoint().tryFillInterested(callback);
    }

    public boolean isFillInterested() {
        return this.getEndPoint().isFillInterested();
    }

    public abstract void onFillable();

    protected void onFillInterestedFailed(Throwable throwable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onFillInterestedFailed {}", this, throwable);
        }
        if (this._endPoint.isOpen()) {
            boolean bl = true;
            if (throwable instanceof TimeoutException) {
                bl = this.onReadTimeout(throwable);
            }
            if (bl) {
                if (this._endPoint.isOutputShutdown()) {
                    this._endPoint.close();
                } else {
                    this._endPoint.shutdownOutput();
                    this.fillInterested();
                }
            }
        }
    }

    protected boolean onReadTimeout(Throwable throwable) {
        return true;
    }

    @Override
    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onOpen {}", this);
        }
        for (Connection.Listener listener : this._listeners) {
            this.onOpened(listener);
        }
    }

    private void onOpened(Connection.Listener listener) {
        try {
            listener.onOpened(this);
        }
        catch (Throwable throwable) {
            LOG.info("Failure while notifying listener " + listener, throwable);
        }
    }

    @Override
    public void onClose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onClose {}", this);
        }
        for (Connection.Listener listener : this._listeners) {
            this.onClosed(listener);
        }
    }

    private void onClosed(Connection.Listener listener) {
        try {
            listener.onClosed(this);
        }
        catch (Throwable throwable) {
            LOG.info("Failure while notifying listener " + listener, throwable);
        }
    }

    @Override
    public EndPoint getEndPoint() {
        return this._endPoint;
    }

    @Override
    public void close() {
        this.getEndPoint().close();
    }

    @Override
    public boolean onIdleExpired() {
        return true;
    }

    @Override
    public long getMessagesIn() {
        return -1L;
    }

    @Override
    public long getMessagesOut() {
        return -1L;
    }

    @Override
    public long getBytesIn() {
        return -1L;
    }

    @Override
    public long getBytesOut() {
        return -1L;
    }

    @Override
    public long getCreatedTimeStamp() {
        return this._created;
    }

    public final String toString() {
        return String.format("%s@%h::%s", this.getClass().getSimpleName(), this, this.getEndPoint());
    }

    public String toConnectionString() {
        return String.format("%s@%h", this.getClass().getSimpleName(), this);
    }

    private class ReadCallback
    implements Callback {
        private ReadCallback() {
        }

        @Override
        public void succeeded() {
            AbstractConnection.this.onFillable();
        }

        @Override
        public void failed(Throwable throwable) {
            AbstractConnection.this.onFillInterestedFailed(throwable);
        }

        public String toString() {
            return String.format("AC.ReadCB@%h{%s}", AbstractConnection.this, AbstractConnection.this);
        }
    }
}

