/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.util.resource.Resource;

public class PrecompressedHttpContent
implements HttpContent {
    private final HttpContent _content;
    private final HttpContent _precompressedContent;
    private final CompressedContentFormat _format;

    public PrecompressedHttpContent(HttpContent httpContent, HttpContent httpContent2, CompressedContentFormat compressedContentFormat) {
        this._content = httpContent;
        this._precompressedContent = httpContent2;
        this._format = compressedContentFormat;
        if (this._precompressedContent == null || this._format == null) {
            throw new NullPointerException("Missing compressed content and/or format");
        }
    }

    public int hashCode() {
        return this._content.hashCode();
    }

    public boolean equals(Object object) {
        return this._content.equals(object);
    }

    @Override
    public Resource getResource() {
        return this._content.getResource();
    }

    @Override
    public HttpField getETag() {
        return new HttpField(HttpHeader.ETAG, this.getETagValue());
    }

    @Override
    public String getETagValue() {
        return this._content.getResource().getWeakETag(this._format.getEtagSuffix());
    }

    @Override
    public HttpField getLastModified() {
        return this._content.getLastModified();
    }

    @Override
    public String getLastModifiedValue() {
        return this._content.getLastModifiedValue();
    }

    @Override
    public HttpField getContentType() {
        return this._content.getContentType();
    }

    @Override
    public String getContentTypeValue() {
        return this._content.getContentTypeValue();
    }

    @Override
    public HttpField getContentEncoding() {
        return this._format.getContentEncoding();
    }

    @Override
    public String getContentEncodingValue() {
        return this._format.getContentEncoding().getValue();
    }

    @Override
    public String getCharacterEncoding() {
        return this._content.getCharacterEncoding();
    }

    @Override
    public MimeTypes.Type getMimeType() {
        return this._content.getMimeType();
    }

    @Override
    public void release() {
        this._content.release();
    }

    @Override
    public ByteBuffer getIndirectBuffer() {
        return this._precompressedContent.getIndirectBuffer();
    }

    @Override
    public ByteBuffer getDirectBuffer() {
        return this._precompressedContent.getDirectBuffer();
    }

    @Override
    public HttpField getContentLength() {
        return this._precompressedContent.getContentLength();
    }

    @Override
    public long getContentLengthValue() {
        return this._precompressedContent.getContentLengthValue();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this._precompressedContent.getInputStream();
    }

    @Override
    public ReadableByteChannel getReadableByteChannel() throws IOException {
        return this._precompressedContent.getReadableByteChannel();
    }

    public String toString() {
        return String.format("%s@%x{e=%s,r=%s|%s,lm=%s|%s,ct=%s}", this.getClass().getSimpleName(), this.hashCode(), this._format, this._content.getResource(), this._precompressedContent.getResource(), this._content.getResource().lastModified(), this._precompressedContent.getResource().lastModified(), this.getContentType());
    }

    public Map<CompressedContentFormat, HttpContent> getPrecompressedContents() {
        return null;
    }
}

