/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import org.eclipse.jetty.util.ArrayTernaryTrie;
import org.eclipse.jetty.util.Trie;

@Deprecated
public class PathMap<O>
extends HashMap<String, O> {
    private static String __pathSpecSeparators = ":,";
    Trie<MappedEntry<O>> _prefixMap = new ArrayTernaryTrie<MappedEntry<O>>(false);
    Trie<MappedEntry<O>> _suffixMap = new ArrayTernaryTrie<MappedEntry<O>>(false);
    final Map<String, MappedEntry<O>> _exactMap = new HashMap<String, MappedEntry<O>>();
    List<MappedEntry<O>> _defaultSingletonList = null;
    MappedEntry<O> _prefixDefault = null;
    MappedEntry<O> _default = null;
    boolean _nodefault = false;

    public static void setPathSpecSeparators(String string) {
        __pathSpecSeparators = string;
    }

    public PathMap() {
        this(11);
    }

    public PathMap(boolean bl) {
        this(11, bl);
    }

    public PathMap(int n) {
        this(n, false);
    }

    private PathMap(int n, boolean bl) {
        super(n);
        this._nodefault = bl;
    }

    public PathMap(Map<String, ? extends O> map) {
        this.putAll(map);
    }

    @Override
    public O put(String string, O o) {
        if ("".equals(string.trim())) {
            MappedEntry<O> mappedEntry = new MappedEntry<O>("", o);
            mappedEntry.setMapped("");
            this._exactMap.put("", mappedEntry);
            return super.put("", o);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, __pathSpecSeparators);
        O o2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken();
            if (!string3.startsWith("/") && !string3.startsWith("*.")) {
                throw new IllegalArgumentException("PathSpec " + string3 + ". must start with '/' or '*.'");
            }
            o2 = super.put(string3, o);
            MappedEntry<O> mappedEntry = new MappedEntry<O>(string3, o);
            if (!mappedEntry.getKey().equals(string3)) continue;
            if (string3.equals("/*")) {
                this._prefixDefault = mappedEntry;
                continue;
            }
            if (string3.endsWith("/*")) {
                string2 = string3.substring(0, string3.length() - 2);
                mappedEntry.setMapped(string2);
                while (!this._prefixMap.put(string2, mappedEntry)) {
                    this._prefixMap = new ArrayTernaryTrie<MappedEntry<O>>((ArrayTernaryTrie)this._prefixMap, 1.5);
                }
                continue;
            }
            if (string3.startsWith("*.")) {
                string2 = string3.substring(2);
                while (!this._suffixMap.put(string2, mappedEntry)) {
                    this._suffixMap = new ArrayTernaryTrie<MappedEntry<O>>((ArrayTernaryTrie)this._suffixMap, 1.5);
                }
                continue;
            }
            if (string3.equals("/")) {
                if (this._nodefault) {
                    this._exactMap.put(string3, mappedEntry);
                    continue;
                }
                this._default = mappedEntry;
                this._defaultSingletonList = Collections.singletonList(this._default);
                continue;
            }
            mappedEntry.setMapped(string3);
            this._exactMap.put(string3, mappedEntry);
        }
        return o2;
    }

    public O match(String string) {
        MappedEntry<O> mappedEntry = this.getMatch(string);
        if (mappedEntry != null) {
            return mappedEntry.getValue();
        }
        return null;
    }

    public MappedEntry<O> getMatch(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        int n = string.length();
        MappedEntry mappedEntry = null;
        if (n == 1 && string.charAt(0) == '/' && (mappedEntry = this._exactMap.get("")) != null) {
            return mappedEntry;
        }
        mappedEntry = this._exactMap.get(string);
        if (mappedEntry != null) {
            return mappedEntry;
        }
        int n2 = n;
        Trie<MappedEntry<O>> trie = this._prefixMap;
        while (n2 >= 0 && (mappedEntry = trie.getBest(string, 0, n2)) != null) {
            object = mappedEntry.getKey();
            if (((String)object).length() - 2 >= string.length() || string.charAt(((String)object).length() - 2) == '/') {
                return mappedEntry;
            }
            n2 = ((String)object).length() - 3;
        }
        if (this._prefixDefault != null) {
            return this._prefixDefault;
        }
        n2 = 0;
        object = this._suffixMap;
        while ((n2 = string.indexOf(46, n2 + 1)) > 0) {
            mappedEntry = (MappedEntry)object.get(string, n2 + 1, n - n2 - 1);
            if (mappedEntry == null) continue;
            return mappedEntry;
        }
        return this._default;
    }

    public List<? extends Map.Entry<String, O>> getMatches(String string) {
        Object object;
        int n;
        ArrayList<MappedEntry<O>> arrayList = new ArrayList<MappedEntry<O>>();
        if (string == null) {
            return arrayList;
        }
        if (string.isEmpty()) {
            return this._defaultSingletonList;
        }
        MappedEntry mappedEntry = this._exactMap.get(string);
        if (mappedEntry != null) {
            arrayList.add(mappedEntry);
        }
        int n2 = n = string.length();
        Trie<MappedEntry<O>> trie = this._prefixMap;
        while (n2 >= 0 && (mappedEntry = trie.getBest(string, 0, n2)) != null) {
            object = mappedEntry.getKey();
            if (((String)object).length() - 2 >= string.length() || string.charAt(((String)object).length() - 2) == '/') {
                arrayList.add(mappedEntry);
            }
            n2 = ((String)object).length() - 3;
        }
        if (this._prefixDefault != null) {
            arrayList.add(this._prefixDefault);
        }
        n2 = 0;
        object = this._suffixMap;
        while ((n2 = string.indexOf(46, n2 + 1)) > 0) {
            mappedEntry = (MappedEntry)object.get(string, n2 + 1, n - n2 - 1);
            if (mappedEntry == null) continue;
            arrayList.add(mappedEntry);
        }
        if ("/".equals(string) && (mappedEntry = this._exactMap.get("")) != null) {
            arrayList.add(mappedEntry);
        }
        if (this._default != null) {
            arrayList.add(this._default);
        }
        return arrayList;
    }

    public boolean containsMatch(String string) {
        MappedEntry<O> mappedEntry = this.getMatch(string);
        return mappedEntry != null && !mappedEntry.equals(this._default);
    }

    @Override
    public O remove(Object object) {
        if (object != null) {
            String string = (String)object;
            if (string.equals("/*")) {
                this._prefixDefault = null;
            } else if (string.endsWith("/*")) {
                this._prefixMap.remove(string.substring(0, string.length() - 2));
            } else if (string.startsWith("*.")) {
                this._suffixMap.remove(string.substring(2));
            } else if (string.equals("/")) {
                this._default = null;
                this._defaultSingletonList = null;
            } else {
                this._exactMap.remove(string);
            }
        }
        return (O)super.remove(object);
    }

    @Override
    public void clear() {
        this._exactMap.clear();
        this._prefixMap = new ArrayTernaryTrie<MappedEntry<O>>(false);
        this._suffixMap = new ArrayTernaryTrie<MappedEntry<O>>(false);
        this._default = null;
        this._defaultSingletonList = null;
        this._prefixDefault = null;
        super.clear();
    }

    public static boolean match(String string, String string2) {
        return PathMap.match(string, string2, false);
    }

    public static boolean match(String string, String string2, boolean bl) {
        if (string.isEmpty()) {
            return "/".equals(string2);
        }
        char c = string.charAt(0);
        if (c == '/') {
            if (!bl && string.length() == 1 || string.equals(string2)) {
                return true;
            }
            return PathMap.isPathWildcardMatch(string, string2);
        }
        if (c == '*') {
            return string2.regionMatches(string2.length() - string.length() + 1, string, 1, string.length() - 1);
        }
        return false;
    }

    private static boolean isPathWildcardMatch(String string, String string2) {
        int n = string.length() - 2;
        if (string.endsWith("/*") && string2.regionMatches(0, string, 0, n)) {
            return string2.length() == n || '/' == string2.charAt(n);
        }
        return false;
    }

    public static String pathMatch(String string, String string2) {
        char c = string.charAt(0);
        if (c == '/') {
            if (string.length() == 1) {
                return string2;
            }
            if (string.equals(string2)) {
                return string2;
            }
            if (PathMap.isPathWildcardMatch(string, string2)) {
                return string2.substring(0, string.length() - 2);
            }
        } else if (c == '*' && string2.regionMatches(string2.length() - (string.length() - 1), string, 1, string.length() - 1)) {
            return string2;
        }
        return null;
    }

    public static String pathInfo(String string, String string2) {
        if ("".equals(string)) {
            return string2;
        }
        char c = string.charAt(0);
        if (c == '/') {
            if (string.length() == 1) {
                return null;
            }
            boolean bl = PathMap.isPathWildcardMatch(string, string2);
            if (string.equals(string2) && !bl) {
                return null;
            }
            if (bl) {
                if (string2.length() == string.length() - 2) {
                    return null;
                }
                return string2.substring(string.length() - 2);
            }
        }
        return null;
    }

    public static String relativePath(String string, String string2, String string3) {
        String string4 = PathMap.pathInfo(string2, string3);
        if (string4 == null) {
            string4 = string3;
        }
        if (string4.startsWith("./")) {
            string4 = string4.substring(2);
        }
        string3 = string.endsWith("/") ? (string4.startsWith("/") ? string + string4.substring(1) : string + string4) : (string4.startsWith("/") ? string + string4 : string + "/" + string4);
        return string3;
    }

    public static class PathSet
    extends AbstractSet<String>
    implements Predicate<String> {
        private final PathMap<Boolean> _map = new PathMap();

        @Override
        public Iterator<String> iterator() {
            return this._map.keySet().iterator();
        }

        @Override
        public int size() {
            return this._map.size();
        }

        @Override
        public boolean add(String string) {
            return this._map.put(string, Boolean.TRUE) == null;
        }

        @Override
        public boolean remove(Object object) {
            return this._map.remove(object) != null;
        }

        @Override
        public boolean contains(Object object) {
            return this._map.containsKey(object);
        }

        @Override
        public boolean test(String string) {
            return this._map.containsMatch(string);
        }

        public boolean containsMatch(String string) {
            return this._map.containsMatch(string);
        }
    }

    public static class MappedEntry<O>
    implements Map.Entry<String, O> {
        private final String key;
        private final O value;
        private String mapped;

        MappedEntry(String string, O o) {
            this.key = string;
            this.value = o;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public O getValue() {
            return this.value;
        }

        @Override
        public O setValue(O o) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        public String getMapped() {
            return this.mapped;
        }

        void setMapped(String string) {
            this.mapped = string;
        }
    }
}

