/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpTokens;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.SearchPattern;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class MultiPartParser {
    public static final Logger LOG = Log.getLogger(MultiPartParser.class);
    private static final EnumSet<State> __delimiterStates = EnumSet.of(State.DELIMITER, State.DELIMITER_CLOSE, State.DELIMITER_PADDING);
    private static final int MAX_HEADER_LINE_LENGTH = 998;
    private final boolean debug = LOG.isDebugEnabled();
    private final Handler _handler;
    private final SearchPattern _delimiterSearch;
    private String _fieldName;
    private String _fieldValue;
    private State _state = State.PREAMBLE;
    private FieldState _fieldState = FieldState.FIELD;
    private int _partialBoundary = 2;
    private boolean _cr;
    private ByteBuffer _patternBuffer;
    private final Utf8StringBuilder _string = new Utf8StringBuilder();
    private int _length;
    private int _totalHeaderLineLength = -1;

    public MultiPartParser(Handler handler, String string) {
        this._handler = handler;
        String string2 = "\r\n--" + string;
        this._patternBuffer = ByteBuffer.wrap(string2.getBytes(StandardCharsets.US_ASCII));
        this._delimiterSearch = SearchPattern.compile(this._patternBuffer.array());
    }

    public void reset() {
        this._state = State.PREAMBLE;
        this._fieldState = FieldState.FIELD;
        this._partialBoundary = 2;
    }

    public Handler getHandler() {
        return this._handler;
    }

    public State getState() {
        return this._state;
    }

    public boolean isState(State state) {
        return this._state == state;
    }

    private static boolean hasNextByte(ByteBuffer byteBuffer) {
        return BufferUtil.hasContent(byteBuffer);
    }

    private HttpTokens.Token next(ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        HttpTokens.Token token = HttpTokens.TOKENS[0xFF & by];
        switch (token.getType()) {
            case CNTL: {
                throw new IllegalCharacterException(this._state, token, byteBuffer);
            }
            case LF: {
                this._cr = false;
                break;
            }
            case CR: {
                if (this._cr) {
                    throw new BadMessageException("Bad EOL");
                }
                this._cr = true;
                return null;
            }
            case ALPHA: 
            case DIGIT: 
            case TCHAR: 
            case VCHAR: 
            case HTAB: 
            case SPACE: 
            case OTEXT: 
            case COLON: {
                if (!this._cr) break;
                throw new BadMessageException("Bad EOL");
            }
        }
        return token;
    }

    private void setString(String string) {
        this._string.reset();
        this._string.append(string);
        this._length = string.length();
    }

    private String takeString() {
        String string = this._string.toString();
        if (string.length() > this._length) {
            string = string.substring(0, this._length);
        }
        this._string.reset();
        this._length = -1;
        return string;
    }

    public boolean parse(ByteBuffer byteBuffer, boolean bl) {
        boolean bl2 = false;
        block8: while (!bl2 && BufferUtil.hasContent(byteBuffer)) {
            switch (this._state) {
                case PREAMBLE: {
                    this.parsePreamble(byteBuffer);
                    continue block8;
                }
                case DELIMITER: 
                case DELIMITER_PADDING: 
                case DELIMITER_CLOSE: {
                    this.parseDelimiter(byteBuffer);
                    continue block8;
                }
                case BODY_PART: {
                    bl2 = this.parseMimePartHeaders(byteBuffer);
                    continue block8;
                }
                case FIRST_OCTETS: 
                case OCTETS: {
                    bl2 = this.parseOctetContent(byteBuffer);
                    continue block8;
                }
                case EPILOGUE: {
                    BufferUtil.clear(byteBuffer);
                    continue block8;
                }
                case END: {
                    bl2 = true;
                    continue block8;
                }
            }
            throw new IllegalStateException();
        }
        if (bl && BufferUtil.isEmpty(byteBuffer)) {
            if (this._state == State.EPILOGUE) {
                this._state = State.END;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("messageComplete {}", this);
                }
                return this._handler.messageComplete();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("earlyEOF {}", this);
            }
            this._handler.earlyEOF();
            return true;
        }
        return bl2;
    }

    private void parsePreamble(ByteBuffer byteBuffer) {
        int n;
        if (LOG.isDebugEnabled()) {
            LOG.debug("parsePreamble({})", BufferUtil.toDetailString(byteBuffer));
        }
        if (this._partialBoundary > 0) {
            n = this._delimiterSearch.startsWith(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining(), this._partialBoundary);
            if (n > 0) {
                if (n == this._delimiterSearch.getLength()) {
                    byteBuffer.position(byteBuffer.position() + n - this._partialBoundary);
                    this._partialBoundary = 0;
                    this.setState(State.DELIMITER);
                    return;
                }
                this._partialBoundary = n;
                BufferUtil.clear(byteBuffer);
                return;
            }
            this._partialBoundary = 0;
        }
        if ((n = this._delimiterSearch.match(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining())) >= 0) {
            byteBuffer.position(n - byteBuffer.arrayOffset() + this._delimiterSearch.getLength());
            this.setState(State.DELIMITER);
            return;
        }
        this._partialBoundary = this._delimiterSearch.endsWith(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        BufferUtil.clear(byteBuffer);
    }

    private void parseDelimiter(ByteBuffer byteBuffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("parseDelimiter({})", BufferUtil.toDetailString(byteBuffer));
        }
        block4: while (__delimiterStates.contains((Object)this._state) && MultiPartParser.hasNextByte(byteBuffer)) {
            HttpTokens.Token token = this.next(byteBuffer);
            if (token == null) {
                return;
            }
            if (token.getType() == HttpTokens.Type.LF) {
                this.setState(State.BODY_PART);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("startPart {}", this);
                }
                this._handler.startPart();
                return;
            }
            switch (this._state) {
                case DELIMITER: {
                    if (token.getChar() == '-') {
                        this.setState(State.DELIMITER_CLOSE);
                        continue block4;
                    }
                    this.setState(State.DELIMITER_PADDING);
                    continue block4;
                }
                case DELIMITER_CLOSE: {
                    if (token.getChar() == '-') {
                        this.setState(State.EPILOGUE);
                        return;
                    }
                    this.setState(State.DELIMITER_PADDING);
                    continue block4;
                }
            }
        }
    }

    protected boolean parseMimePartHeaders(ByteBuffer byteBuffer) {
        HttpTokens.Token token;
        if (LOG.isDebugEnabled()) {
            LOG.debug("parseMimePartHeaders({})", BufferUtil.toDetailString(byteBuffer));
        }
        block33: while (this._state == State.BODY_PART && MultiPartParser.hasNextByte(byteBuffer) && (token = this.next(byteBuffer)) != null) {
            if (token.getType() != HttpTokens.Type.LF) {
                ++this._totalHeaderLineLength;
            }
            if (this._totalHeaderLineLength > 998) {
                throw new IllegalStateException("Header Line Exceeded Max Length");
            }
            switch (this._fieldState) {
                case FIELD: {
                    switch (token.getType()) {
                        case HTAB: 
                        case SPACE: {
                            if (this._fieldName == null) {
                                throw new IllegalStateException("First field folded");
                            }
                            if (this._fieldValue == null) {
                                this._string.reset();
                                this._length = 0;
                            } else {
                                this.setString(this._fieldValue);
                                this._string.append(' ');
                                ++this._length;
                                this._fieldValue = null;
                            }
                            this.setState(FieldState.VALUE);
                            continue block33;
                        }
                        case LF: {
                            this.handleField();
                            this.setState(State.FIRST_OCTETS);
                            this._partialBoundary = 2;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("headerComplete {}", this);
                            }
                            if (!this._handler.headerComplete()) continue block33;
                            return true;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: {
                            this.handleField();
                            this.setState(FieldState.IN_NAME);
                            this._string.reset();
                            this._string.append(token.getChar());
                            this._length = 1;
                            continue block33;
                        }
                    }
                    throw new IllegalCharacterException(this._state, token, byteBuffer);
                }
                case IN_NAME: {
                    switch (token.getType()) {
                        case COLON: {
                            this._fieldName = this.takeString();
                            this._length = -1;
                            this.setState(FieldState.VALUE);
                            continue block33;
                        }
                        case SPACE: {
                            this.setState(FieldState.AFTER_NAME);
                            continue block33;
                        }
                        case LF: {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Line Feed in Name {}", this);
                            }
                            this.handleField();
                            this.setState(FieldState.FIELD);
                            continue block33;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: {
                            this._string.append(token.getChar());
                            this._length = this._string.length();
                            continue block33;
                        }
                    }
                    throw new IllegalCharacterException(this._state, token, byteBuffer);
                }
                case AFTER_NAME: {
                    switch (token.getType()) {
                        case COLON: {
                            this._fieldName = this.takeString();
                            this._length = -1;
                            this.setState(FieldState.VALUE);
                            continue block33;
                        }
                        case LF: {
                            this._fieldName = this.takeString();
                            this._string.reset();
                            this._fieldValue = "";
                            this._length = -1;
                            continue block33;
                        }
                        case SPACE: {
                            continue block33;
                        }
                    }
                    throw new IllegalCharacterException(this._state, token, byteBuffer);
                }
                case VALUE: {
                    switch (token.getType()) {
                        case LF: {
                            this._string.reset();
                            this._fieldValue = "";
                            this._length = -1;
                            this.setState(FieldState.FIELD);
                            continue block33;
                        }
                        case HTAB: 
                        case SPACE: {
                            continue block33;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: 
                        case VCHAR: 
                        case OTEXT: 
                        case COLON: {
                            this._string.append(token.getByte());
                            this._length = this._string.length();
                            this.setState(FieldState.IN_VALUE);
                            continue block33;
                        }
                    }
                    throw new IllegalCharacterException(this._state, token, byteBuffer);
                }
                case IN_VALUE: {
                    switch (token.getType()) {
                        case HTAB: 
                        case SPACE: {
                            this._string.append(' ');
                            continue block33;
                        }
                        case LF: {
                            if (this._length > 0) {
                                this._fieldValue = this.takeString();
                                this._length = -1;
                                this._totalHeaderLineLength = -1;
                            }
                            this.setState(FieldState.FIELD);
                            continue block33;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: 
                        case VCHAR: 
                        case OTEXT: 
                        case COLON: {
                            this._string.append(token.getByte());
                            this._length = this._string.length();
                            continue block33;
                        }
                    }
                    throw new IllegalCharacterException(this._state, token, byteBuffer);
                }
            }
            throw new IllegalStateException(this._state.toString());
        }
        return false;
    }

    private void handleField() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("parsedField:  _fieldName={} _fieldValue={} {}", this._fieldName, this._fieldValue, this);
        }
        if (this._fieldName != null && this._fieldValue != null) {
            this._handler.parsedField(this._fieldName, this._fieldValue);
        }
        this._fieldValue = null;
        this._fieldName = null;
    }

    protected boolean parseOctetContent(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2;
        int n;
        if (LOG.isDebugEnabled()) {
            LOG.debug("parseOctetContent({})", BufferUtil.toDetailString(byteBuffer));
        }
        if (this._partialBoundary > 0) {
            n = this._delimiterSearch.startsWith(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining(), this._partialBoundary);
            if (n > 0) {
                if (n == this._delimiterSearch.getLength()) {
                    byteBuffer.position(byteBuffer.position() + this._delimiterSearch.getLength() - this._partialBoundary);
                    this.setState(State.DELIMITER);
                    this._partialBoundary = 0;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Content={}, Last={} {}", BufferUtil.toDetailString(BufferUtil.EMPTY_BUFFER), true, this);
                    }
                    return this._handler.content(BufferUtil.EMPTY_BUFFER, true);
                }
                this._partialBoundary = n;
                BufferUtil.clear(byteBuffer);
                return false;
            }
            byteBuffer2 = this._patternBuffer.slice();
            if (this._state == State.FIRST_OCTETS) {
                this.setState(State.OCTETS);
                byteBuffer2.position(2);
            }
            byteBuffer2.limit(this._partialBoundary);
            this._partialBoundary = 0;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Content={}, Last={} {}", BufferUtil.toDetailString(byteBuffer2), false, this);
            }
            if (this._handler.content(byteBuffer2, false)) {
                return true;
            }
        }
        if ((n = this._delimiterSearch.match(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining())) >= 0) {
            byteBuffer2 = byteBuffer.slice();
            byteBuffer2.limit(n - byteBuffer.arrayOffset() - byteBuffer.position());
            byteBuffer.position(n - byteBuffer.arrayOffset() + this._delimiterSearch.getLength());
            this.setState(State.DELIMITER);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Content={}, Last={} {}", BufferUtil.toDetailString(byteBuffer2), true, this);
            }
            return this._handler.content(byteBuffer2, true);
        }
        this._partialBoundary = this._delimiterSearch.endsWith(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        if (this._partialBoundary > 0) {
            byteBuffer2 = byteBuffer.slice();
            byteBuffer2.limit(byteBuffer2.limit() - this._partialBoundary);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Content={}, Last={} {}", BufferUtil.toDetailString(byteBuffer2), false, this);
            }
            BufferUtil.clear(byteBuffer);
            return this._handler.content(byteBuffer2, false);
        }
        byteBuffer2 = byteBuffer.slice();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Content={}, Last={} {}", BufferUtil.toDetailString(byteBuffer2), false, this);
        }
        BufferUtil.clear(byteBuffer);
        return this._handler.content(byteBuffer2, false);
    }

    private void setState(State state) {
        if (this.debug) {
            LOG.debug("{} --> {}", new Object[]{this._state, state});
        }
        this._state = state;
    }

    private void setState(FieldState fieldState) {
        if (this.debug) {
            LOG.debug("{}:{} --> {}", new Object[]{this._state, this._fieldState, fieldState});
        }
        this._fieldState = fieldState;
    }

    public String toString() {
        return String.format("%s{s=%s}", new Object[]{this.getClass().getSimpleName(), this._state});
    }

    private static class IllegalCharacterException
    extends BadMessageException {
        private IllegalCharacterException(State state, HttpTokens.Token token, ByteBuffer byteBuffer) {
            super(400, String.format("Illegal character %s", token));
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Illegal character %s in state=%s for buffer %s", new Object[]{token, state, BufferUtil.toDetailString(byteBuffer)}), new Object[0]);
            }
        }
    }

    public static interface Handler {
        default public void startPart() {
        }

        default public void parsedField(String string, String string2) {
        }

        default public boolean headerComplete() {
            return false;
        }

        default public boolean content(ByteBuffer byteBuffer, boolean bl) {
            return false;
        }

        default public boolean messageComplete() {
            return false;
        }

        default public void earlyEOF() {
        }
    }

    public static enum State {
        PREAMBLE,
        DELIMITER,
        DELIMITER_PADDING,
        DELIMITER_CLOSE,
        BODY_PART,
        FIRST_OCTETS,
        OCTETS,
        EPILOGUE,
        END;

    }

    public static enum FieldState {
        FIELD,
        IN_NAME,
        AFTER_NAME,
        VALUE,
        IN_VALUE;

    }
}

