/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.DateParser;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.http.QuotedCSVParser;
import org.eclipse.jetty.http.QuotedQualityCSV;
import org.eclipse.jetty.util.ArrayTernaryTrie;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpFields
implements Iterable<HttpField> {
    @Deprecated
    public static final String __separators = ", \t";
    private static final Logger LOG = Log.getLogger(HttpFields.class);
    private HttpField[] _fields;
    private int _size;
    @Deprecated
    private static final Float __one = new Float("1.0");
    @Deprecated
    private static final Float __zero = new Float("0.0");
    @Deprecated
    private static final Trie<Float> __qualities = new ArrayTernaryTrie<Float>();

    public HttpFields() {
        this(16);
    }

    public HttpFields(int n) {
        this._fields = new HttpField[n];
    }

    public HttpFields(HttpFields httpFields) {
        this._fields = Arrays.copyOf(httpFields._fields, httpFields._fields.length);
        this._size = httpFields._size;
    }

    public void computeField(HttpHeader httpHeader2, BiFunction<HttpHeader, List<HttpField>, HttpField> biFunction) {
        this.computeField(httpHeader2, biFunction, (httpField, httpHeader) -> httpField.getHeader() == httpHeader);
    }

    public void computeField(String string, BiFunction<String, List<HttpField>, HttpField> biFunction) {
        this.computeField(string, biFunction, HttpField::is);
    }

    private <T> void computeField(T t, BiFunction<T, List<HttpField>, HttpField> biFunction, BiFunction<HttpField, T, Boolean> biFunction2) {
        int n = -1;
        for (int i = 0; i < this._size; ++i) {
            HttpField httpField = this._fields[i];
            if (!biFunction2.apply(httpField, (HttpField)t).booleanValue()) continue;
            n = i;
            break;
        }
        if (n < 0) {
            HttpField httpField = biFunction.apply(t, null);
            if (httpField != null) {
                this.add(httpField);
            }
            return;
        }
        List<Object> list = null;
        for (int i = n + 1; i < this._size; ++i) {
            HttpField httpField = this._fields[i];
            if (!biFunction2.apply(httpField, (HttpField)t).booleanValue()) continue;
            if (list == null) {
                list = new ArrayList();
                list.add(this._fields[n]);
            }
            list.add(httpField);
            this.remove(i--);
        }
        HttpField httpField = biFunction.apply(t, list = list == null ? Collections.singletonList(this._fields[n]) : Collections.unmodifiableList(list));
        if (httpField == null) {
            this.remove(n);
        } else {
            this._fields[n] = httpField;
        }
    }

    public int size() {
        return this._size;
    }

    @Override
    public Iterator<HttpField> iterator() {
        return new ListItr();
    }

    public ListIterator<HttpField> listIterator() {
        return new ListItr();
    }

    public Stream<HttpField> stream() {
        return Arrays.stream(this._fields).limit(this._size);
    }

    public Set<String> getFieldNamesCollection() {
        HashSet<String> hashSet = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField httpField = this._fields[i];
            if (hashSet == null) {
                hashSet = new HashSet<String>();
            }
            hashSet.add(httpField.getName());
        }
        return hashSet == null ? Collections.emptySet() : hashSet;
    }

    public Enumeration<String> getFieldNames() {
        return Collections.enumeration(this.getFieldNamesCollection());
    }

    public HttpField getField(int n) {
        if (n >= this._size) {
            throw new NoSuchElementException();
        }
        return this._fields[n];
    }

    public HttpField getField(HttpHeader httpHeader) {
        for (int i = 0; i < this._size; ++i) {
            HttpField httpField = this._fields[i];
            if (httpField.getHeader() != httpHeader) continue;
            return httpField;
        }
        return null;
    }

    public HttpField getField(String string) {
        for (int i = 0; i < this._size; ++i) {
            HttpField httpField = this._fields[i];
            if (!httpField.is(string)) continue;
            return httpField;
        }
        return null;
    }

    public List<HttpField> getFields(HttpHeader httpHeader) {
        ArrayList<HttpField> arrayList = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField httpField = this._fields[i];
            if (httpField.getHeader() != httpHeader) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<HttpField>();
            }
            arrayList.add(httpField);
        }
        return arrayList == null ? Collections.emptyList() : arrayList;
    }

    public List<HttpField> getFields(String string) {
        ArrayList<HttpField> arrayList = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField httpField = this._fields[i];
            if (!httpField.is(string)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<HttpField>();
            }
            arrayList.add(httpField);
        }
        return arrayList == null ? Collections.emptyList() : arrayList;
    }

    public boolean contains(HttpField httpField) {
        int n = this._size;
        while (n-- > 0) {
            HttpField httpField2 = this._fields[n];
            if (!httpField2.isSameName(httpField) || !httpField2.equals(httpField) && !httpField2.contains(httpField.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean contains(HttpHeader httpHeader, String string) {
        int n = this._size;
        while (n-- > 0) {
            HttpField httpField = this._fields[n];
            if (httpField.getHeader() != httpHeader || !httpField.contains(string)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String string, String string2) {
        int n = this._size;
        while (n-- > 0) {
            HttpField httpField = this._fields[n];
            if (!httpField.is(string) || !httpField.contains(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(HttpHeader httpHeader) {
        int n = this._size;
        while (n-- > 0) {
            HttpField httpField = this._fields[n];
            if (httpField.getHeader() != httpHeader) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(String string) {
        int n = this._size;
        while (n-- > 0) {
            HttpField httpField = this._fields[n];
            if (!httpField.is(string)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public String getStringField(HttpHeader httpHeader) {
        return this.get(httpHeader);
    }

    public String get(HttpHeader httpHeader) {
        for (int i = 0; i < this._size; ++i) {
            HttpField httpField = this._fields[i];
            if (httpField.getHeader() != httpHeader) continue;
            return httpField.getValue();
        }
        return null;
    }

    @Deprecated
    public String getStringField(String string) {
        return this.get(string);
    }

    public String get(String string) {
        for (int i = 0; i < this._size; ++i) {
            HttpField httpField = this._fields[i];
            if (!httpField.is(string)) continue;
            return httpField.getValue();
        }
        return null;
    }

    public List<String> getValuesList(HttpHeader httpHeader) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this._size; ++i) {
            HttpField httpField = this._fields[i];
            if (httpField.getHeader() != httpHeader) continue;
            arrayList.add(httpField.getValue());
        }
        return arrayList;
    }

    public List<String> getValuesList(String string) {
        ArrayList<String> arrayList = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField httpField = this._fields[i];
            if (!httpField.is(string)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>(this.size() - i);
            }
            arrayList.add(httpField.getValue());
        }
        return arrayList == null ? Collections.emptyList() : arrayList;
    }

    public boolean addCSV(HttpHeader httpHeader, String ... stringArray) {
        QuotedCSVParser quotedCSVParser = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField httpField = this._fields[i];
            if (httpField.getHeader() != httpHeader) continue;
            if (quotedCSVParser == null) {
                quotedCSVParser = new QuotedCSV(false, new String[0]);
            }
            quotedCSVParser.addValue(httpField.getValue());
        }
        String string = this.addCSV((QuotedCSV)quotedCSVParser, stringArray);
        if (string != null) {
            this.add(httpHeader, string);
            return true;
        }
        return false;
    }

    public boolean addCSV(String string, String ... stringArray) {
        QuotedCSVParser quotedCSVParser = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField httpField = this._fields[i];
            if (!httpField.is(string)) continue;
            if (quotedCSVParser == null) {
                quotedCSVParser = new QuotedCSV(false, new String[0]);
            }
            quotedCSVParser.addValue(httpField.getValue());
        }
        String string2 = this.addCSV((QuotedCSV)quotedCSVParser, stringArray);
        if (string2 != null) {
            this.add(string, string2);
            return true;
        }
        return false;
    }

    protected String addCSV(QuotedCSV quotedCSV, String ... stringArray) {
        boolean bl = true;
        if (quotedCSV != null && !quotedCSV.isEmpty()) {
            bl = false;
            int n = stringArray.length;
            while (n-- > 0) {
                String object = QuotedCSV.unquote(stringArray[n]);
                if (quotedCSV.getValues().contains(object)) {
                    stringArray[n] = null;
                    continue;
                }
                bl = true;
            }
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                if (string == null) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string);
            }
            if (stringBuilder.length() > 0) {
                return stringBuilder.toString();
            }
        }
        return null;
    }

    public List<String> getCSV(HttpHeader httpHeader, boolean bl) {
        QuotedCSV quotedCSV = null;
        for (HttpField httpField : this) {
            if (httpField.getHeader() != httpHeader) continue;
            if (quotedCSV == null) {
                quotedCSV = new QuotedCSV(bl, new String[0]);
            }
            quotedCSV.addValue(httpField.getValue());
        }
        return quotedCSV == null ? Collections.emptyList() : quotedCSV.getValues();
    }

    public List<String> getCSV(String string, boolean bl) {
        QuotedCSV quotedCSV = null;
        for (HttpField httpField : this) {
            if (!httpField.is(string)) continue;
            if (quotedCSV == null) {
                quotedCSV = new QuotedCSV(bl, new String[0]);
            }
            quotedCSV.addValue(httpField.getValue());
        }
        return quotedCSV == null ? Collections.emptyList() : quotedCSV.getValues();
    }

    public List<String> getQualityCSV(HttpHeader httpHeader) {
        return this.getQualityCSV(httpHeader, null);
    }

    public List<String> getQualityCSV(HttpHeader httpHeader, ToIntFunction<String> toIntFunction) {
        QuotedQualityCSV quotedQualityCSV = null;
        for (HttpField httpField : this) {
            if (httpField.getHeader() != httpHeader) continue;
            if (quotedQualityCSV == null) {
                quotedQualityCSV = new QuotedQualityCSV(toIntFunction);
            }
            quotedQualityCSV.addValue(httpField.getValue());
        }
        return quotedQualityCSV == null ? Collections.emptyList() : quotedQualityCSV.getValues();
    }

    public List<String> getQualityCSV(String string) {
        QuotedQualityCSV quotedQualityCSV = null;
        for (HttpField httpField : this) {
            if (!httpField.is(string)) continue;
            if (quotedQualityCSV == null) {
                quotedQualityCSV = new QuotedQualityCSV();
            }
            quotedQualityCSV.addValue(httpField.getValue());
        }
        return quotedQualityCSV == null ? Collections.emptyList() : quotedQualityCSV.getValues();
    }

    public Enumeration<String> getValues(final String string) {
        for (int i = 0; i < this._size; ++i) {
            final HttpField httpField = this._fields[i];
            if (!httpField.is(string) || httpField.getValue() == null) continue;
            final int n = i;
            return new Enumeration<String>(){
                HttpField field;
                int i;
                {
                    this.field = httpField;
                    this.i = n + 1;
                }

                @Override
                public boolean hasMoreElements() {
                    if (this.field == null) {
                        while (this.i < HttpFields.this._size) {
                            this.field = HttpFields.this._fields[this.i++];
                            if (!this.field.is(string) || this.field.getValue() == null) continue;
                            return true;
                        }
                        this.field = null;
                        return false;
                    }
                    return true;
                }

                @Override
                public String nextElement() throws NoSuchElementException {
                    if (this.hasMoreElements()) {
                        String string2 = this.field.getValue();
                        this.field = null;
                        return string2;
                    }
                    throw new NoSuchElementException();
                }
            };
        }
        List list = Collections.emptyList();
        return Collections.enumeration(list);
    }

    @Deprecated
    public Enumeration<String> getValues(String string, final String string2) {
        final Enumeration<String> enumeration = this.getValues(string);
        if (enumeration == null) {
            return null;
        }
        return new Enumeration<String>(){
            QuotedStringTokenizer tok = null;

            @Override
            public boolean hasMoreElements() {
                if (this.tok != null && this.tok.hasMoreElements()) {
                    return true;
                }
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (string == null) continue;
                    this.tok = new QuotedStringTokenizer(string, string2, false, false);
                    if (!this.tok.hasMoreElements()) continue;
                    return true;
                }
                this.tok = null;
                return false;
            }

            @Override
            public String nextElement() throws NoSuchElementException {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String string = (String)this.tok.nextElement();
                if (string != null) {
                    string = string.trim();
                }
                return string;
            }
        };
    }

    public void put(HttpField httpField) {
        boolean bl = false;
        int n = this._size;
        while (n-- > 0) {
            HttpField httpField2 = this._fields[n];
            if (!httpField2.isSameName(httpField)) continue;
            if (bl) {
                --this._size;
                System.arraycopy(this._fields, n + 1, this._fields, n, this._size - n);
                continue;
            }
            this._fields[n] = httpField;
            bl = true;
        }
        if (!bl) {
            this.add(httpField);
        }
    }

    public void put(String string, String string2) {
        if (string2 == null) {
            this.remove(string);
        } else {
            this.put(new HttpField(string, string2));
        }
    }

    public void put(HttpHeader httpHeader, HttpHeaderValue httpHeaderValue) {
        this.put(httpHeader, httpHeaderValue.toString());
    }

    public void put(HttpHeader httpHeader, String string) {
        Objects.requireNonNull(httpHeader, "header must not be null");
        if (string == null) {
            this.remove(httpHeader);
        } else {
            this.put(new HttpField(httpHeader, string));
        }
    }

    public void put(String string, List<String> list) {
        Objects.requireNonNull(string, "name must not be null");
        this.remove(string);
        if (list == null) {
            return;
        }
        for (String string2 : list) {
            if (string2 == null) continue;
            this.add(string, string2);
        }
    }

    public void add(String string, String string2) {
        if (string2 == null) {
            return;
        }
        HttpField httpField = new HttpField(string, string2);
        this.add(httpField);
    }

    public void add(HttpHeader httpHeader, HttpHeaderValue httpHeaderValue) {
        if (httpHeaderValue != null) {
            this.add(httpHeader, httpHeaderValue.toString());
        }
    }

    public void add(HttpHeader httpHeader, String string) {
        Objects.requireNonNull(httpHeader, "header must not be null");
        if (string == null) {
            throw new IllegalArgumentException("null value");
        }
        HttpField httpField = new HttpField(httpHeader, string);
        this.add(httpField);
    }

    public HttpField remove(HttpHeader httpHeader) {
        HttpField httpField = null;
        int n = this._size;
        while (n-- > 0) {
            HttpField httpField2 = this._fields[n];
            if (httpField2.getHeader() != httpHeader) continue;
            httpField = httpField2;
            this.remove(n);
        }
        return httpField;
    }

    public HttpField remove(String string) {
        HttpField httpField = null;
        int n = this._size;
        while (n-- > 0) {
            HttpField httpField2 = this._fields[n];
            if (!httpField2.is(string)) continue;
            httpField = httpField2;
            this.remove(n);
        }
        return httpField;
    }

    private void remove(int n) {
        --this._size;
        System.arraycopy(this._fields, n + 1, this._fields, n, this._size - n);
        this._fields[this._size] = null;
    }

    public long getLongField(String string) throws NumberFormatException {
        HttpField httpField = this.getField(string);
        return httpField == null ? -1L : httpField.getLongValue();
    }

    public long getDateField(String string) {
        HttpField httpField = this.getField(string);
        if (httpField == null) {
            return -1L;
        }
        String string2 = HttpFields.valueParameters(httpField.getValue(), null);
        if (string2 == null) {
            return -1L;
        }
        long l = DateParser.parseDate(string2);
        if (l == -1L) {
            throw new IllegalArgumentException("Cannot convert date: " + string2);
        }
        return l;
    }

    public void putLongField(HttpHeader httpHeader, long l) {
        String string = Long.toString(l);
        this.put(httpHeader, string);
    }

    public void putLongField(String string, long l) {
        String string2 = Long.toString(l);
        this.put(string, string2);
    }

    public void putDateField(HttpHeader httpHeader, long l) {
        String string = DateGenerator.formatDate(l);
        this.put(httpHeader, string);
    }

    public void putDateField(String string, long l) {
        String string2 = DateGenerator.formatDate(l);
        this.put(string, string2);
    }

    public void addDateField(String string, long l) {
        String string2 = DateGenerator.formatDate(l);
        this.add(string, string2);
    }

    public int hashCode() {
        int n = 0;
        for (HttpField httpField : this._fields) {
            n += httpField.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HttpFields)) {
            return false;
        }
        HttpFields httpFields = (HttpFields)object;
        if (this.size() != httpFields.size()) {
            return false;
        }
        block0: for (HttpField httpField : this) {
            for (HttpField httpField2 : httpFields) {
                if (!httpField.equals(httpField2)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (HttpField httpField : this) {
                if (httpField == null) continue;
                String string = httpField.getName();
                if (string != null) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(": ");
                string = httpField.getValue();
                if (string != null) {
                    stringBuilder.append(string);
                }
                stringBuilder.append("\r\n");
            }
            stringBuilder.append("\r\n");
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            LOG.warn(exception);
            return exception.toString();
        }
    }

    public void clear() {
        this._size = 0;
    }

    public void add(HttpField httpField) {
        if (httpField != null) {
            if (this._size == this._fields.length) {
                this._fields = Arrays.copyOf(this._fields, this._size * 2);
            }
            this._fields[this._size++] = httpField;
        }
    }

    public void addAll(HttpFields httpFields) {
        for (int i = 0; i < httpFields._size; ++i) {
            this.add(httpFields._fields[i]);
        }
    }

    @Deprecated
    public void add(HttpFields httpFields) {
        if (httpFields == null) {
            return;
        }
        Enumeration<String> enumeration = httpFields.getFieldNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Enumeration<String> enumeration2 = httpFields.getValues(string);
            while (enumeration2.hasMoreElements()) {
                this.add(string, enumeration2.nextElement());
            }
        }
    }

    public static String stripParameters(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(59);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n).trim();
    }

    public static String valueParameters(String string, Map<String, String> map) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(59);
        if (n < 0) {
            return string;
        }
        if (map == null) {
            return string.substring(0, n).trim();
        }
        QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string.substring(n), ";", false, true);
        while (((StringTokenizer)quotedStringTokenizer).hasMoreTokens()) {
            String string2 = ((StringTokenizer)quotedStringTokenizer).nextToken();
            QuotedStringTokenizer quotedStringTokenizer2 = new QuotedStringTokenizer(string2, "= ");
            if (!((StringTokenizer)quotedStringTokenizer2).hasMoreTokens()) continue;
            String string3 = ((StringTokenizer)quotedStringTokenizer2).nextToken();
            String string4 = null;
            if (((StringTokenizer)quotedStringTokenizer2).hasMoreTokens()) {
                string4 = ((StringTokenizer)quotedStringTokenizer2).nextToken();
            }
            map.put(string3, string4);
        }
        return string.substring(0, n).trim();
    }

    @Deprecated
    public static Float getQuality(String string) {
        Float f;
        Serializable serializable;
        if (string == null) {
            return __zero;
        }
        int n = string.indexOf(";");
        if (n++ < 0 || n == string.length()) {
            return __one;
        }
        if (string.charAt(n++) == 'q' && (serializable = __qualities.get(string, ++n, string.length() - n)) != null) {
            return serializable;
        }
        serializable = new HashMap<String, String>(4);
        HttpFields.valueParameters(string, serializable);
        String string2 = (String)serializable.get("q");
        if (string2 == null) {
            string2 = "*";
        }
        if ((f = __qualities.get(string2)) == null) {
            try {
                f = new Float(string2);
            }
            catch (Exception exception) {
                f = __one;
            }
        }
        return f;
    }

    @Deprecated
    public static List<String> qualityList(Enumeration<String> enumeration) {
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return Collections.emptyList();
        }
        QuotedQualityCSV quotedQualityCSV = new QuotedQualityCSV();
        while (enumeration.hasMoreElements()) {
            quotedQualityCSV.addValue(enumeration.nextElement());
        }
        return quotedQualityCSV.getValues();
    }

    static /* synthetic */ HttpField[] access$202(HttpFields httpFields, HttpField[] httpFieldArray) {
        httpFields._fields = httpFieldArray;
        return httpFieldArray;
    }

    static {
        __qualities.put("*", __one);
        __qualities.put("1.0", __one);
        __qualities.put("1", __one);
        __qualities.put("0.9", new Float("0.9"));
        __qualities.put("0.8", new Float("0.8"));
        __qualities.put("0.7", new Float("0.7"));
        __qualities.put("0.66", new Float("0.66"));
        __qualities.put("0.6", new Float("0.6"));
        __qualities.put("0.5", new Float("0.5"));
        __qualities.put("0.4", new Float("0.4"));
        __qualities.put("0.33", new Float("0.33"));
        __qualities.put("0.3", new Float("0.3"));
        __qualities.put("0.2", new Float("0.2"));
        __qualities.put("0.1", new Float("0.1"));
        __qualities.put("0", __zero);
        __qualities.put("0.0", __zero);
    }

    private class ListItr
    implements ListIterator<HttpField> {
        int _cursor;
        int _current = -1;

        private ListItr() {
        }

        @Override
        public boolean hasNext() {
            return this._cursor != HttpFields.this._size;
        }

        @Override
        public HttpField next() {
            if (this._cursor == HttpFields.this._size) {
                throw new NoSuchElementException();
            }
            this._current = this._cursor++;
            return HttpFields.this._fields[this._current];
        }

        @Override
        public void remove() {
            if (this._current < 0) {
                throw new IllegalStateException();
            }
            HttpFields.this.remove(this._current);
            ((HttpFields)HttpFields.this)._fields[((HttpFields)HttpFields.this)._size] = null;
            this._cursor = this._current;
            this._current = -1;
        }

        @Override
        public boolean hasPrevious() {
            return this._cursor > 0;
        }

        @Override
        public HttpField previous() {
            if (this._cursor == 0) {
                throw new NoSuchElementException();
            }
            this._current = --this._cursor;
            return HttpFields.this._fields[this._current];
        }

        @Override
        public int nextIndex() {
            return this._cursor;
        }

        @Override
        public int previousIndex() {
            return this._cursor - 1;
        }

        @Override
        public void set(HttpField httpField) {
            if (this._current < 0) {
                throw new IllegalStateException();
            }
            if (httpField == null) {
                this.remove();
            } else {
                ((HttpFields)HttpFields.this)._fields[this._current] = httpField;
            }
        }

        @Override
        public void add(HttpField httpField) {
            if (httpField != null) {
                HttpFields.access$202(HttpFields.this, Arrays.copyOf(HttpFields.this._fields, HttpFields.this._fields.length + 1));
                System.arraycopy(HttpFields.this._fields, this._cursor, HttpFields.this._fields, this._cursor + 1, HttpFields.this._size - this._cursor);
                ((HttpFields)HttpFields.this)._fields[this._cursor++] = httpField;
                HttpFields.this._size++;
                this._current = -1;
            }
        }
    }
}

