/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Socks4Proxy
extends ProxyConfiguration.Proxy {
    public Socks4Proxy(String string, int n) {
        this(new Origin.Address(string, n), false);
    }

    public Socks4Proxy(Origin.Address address, boolean bl) {
        super(address, bl);
    }

    @Override
    public ClientConnectionFactory newClientConnectionFactory(ClientConnectionFactory clientConnectionFactory) {
        return new Socks4ProxyClientConnectionFactory(clientConnectionFactory);
    }

    private static class Socks4ProxyConnection
    extends AbstractConnection
    implements Callback {
        private static final Pattern IPv4_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
        private static final Logger LOG = Log.getLogger(Socks4ProxyConnection.class);
        private final Socks4Parser parser = new Socks4Parser();
        private final ClientConnectionFactory connectionFactory;
        private final Map<String, Object> context;

        public Socks4ProxyConnection(EndPoint endPoint, Executor executor, ClientConnectionFactory clientConnectionFactory, Map<String, Object> map) {
            super(endPoint, executor);
            this.connectionFactory = clientConnectionFactory;
            this.context = map;
        }

        @Override
        public void onOpen() {
            super.onOpen();
            this.writeSocks4Connect();
        }

        private void writeSocks4Connect() {
            HttpDestination httpDestination = (HttpDestination)this.context.get("http.destination");
            String string = httpDestination.getHost();
            short s = (short)httpDestination.getPort();
            Matcher matcher = IPv4_PATTERN.matcher(string);
            if (matcher.matches()) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(9);
                byteBuffer.put((byte)4).put((byte)1).putShort(s);
                for (int i = 1; i <= 4; ++i) {
                    byteBuffer.put((byte)Integer.parseInt(matcher.group(i)));
                }
                byteBuffer.put((byte)0);
                byteBuffer.flip();
                this.getEndPoint().write(this, byteBuffer);
            } else {
                byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
                ByteBuffer byteBuffer = ByteBuffer.allocate(9 + byArray.length + 1);
                byteBuffer.put((byte)4).put((byte)1).putShort(s);
                byteBuffer.put((byte)0).put((byte)0).put((byte)0).put((byte)1).put((byte)0);
                byteBuffer.put(byArray).put((byte)0);
                byteBuffer.flip();
                this.getEndPoint().write(this, byteBuffer);
            }
        }

        @Override
        public void succeeded() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Written SOCKS4 connect request", new Object[0]);
            }
            this.fillInterested();
        }

        @Override
        public void failed(Throwable throwable) {
            this.close();
            Promise promise = (Promise)this.context.get("http.connection.promise");
            promise.failed(throwable);
        }

        @Override
        public void onFillable() {
            try {
                ByteBuffer byteBuffer;
                do {
                    byteBuffer = BufferUtil.allocate(this.parser.expected());
                    int n = this.getEndPoint().fill(byteBuffer);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Read SOCKS4 connect response, {} bytes", n);
                    }
                    if (n < 0) {
                        throw new IOException("SOCKS4 tunnel failed, connection closed");
                    }
                    if (n != 0) continue;
                    this.fillInterested();
                    return;
                } while (!this.parser.parse(byteBuffer));
                return;
            }
            catch (Throwable throwable) {
                this.failed(throwable);
                return;
            }
        }

        private void onSocks4Response(int n) throws IOException {
            if (n != 90) {
                throw new IOException("SOCKS4 tunnel failed with code " + n);
            }
            this.tunnel();
        }

        private void tunnel() {
            try {
                HttpDestination httpDestination = (HttpDestination)this.context.get("http.destination");
                this.context.put("ssl.peer.host", httpDestination.getHost());
                this.context.put("ssl.peer.port", httpDestination.getPort());
                ClientConnectionFactory clientConnectionFactory = this.connectionFactory;
                if (httpDestination.isSecure()) {
                    clientConnectionFactory = httpDestination.newSslClientConnectionFactory(null, clientConnectionFactory);
                }
                Connection connection = clientConnectionFactory.newConnection(this.getEndPoint(), this.context);
                this.getEndPoint().upgrade(connection);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SOCKS4 tunnel established: {} over {}", this, connection);
                }
            }
            catch (Throwable throwable) {
                this.failed(throwable);
            }
        }

        private class Socks4Parser {
            private static final int EXPECTED_LENGTH = 8;
            private int cursor;
            private int response;

            private Socks4Parser() {
            }

            private boolean parse(ByteBuffer byteBuffer) throws IOException {
                while (byteBuffer.hasRemaining()) {
                    byte by = byteBuffer.get();
                    if (this.cursor == 1) {
                        this.response = by & 0xFF;
                    }
                    ++this.cursor;
                    if (this.cursor != 8) continue;
                    Socks4ProxyConnection.this.onSocks4Response(this.response);
                    return true;
                }
                return false;
            }

            private int expected() {
                return 8 - this.cursor;
            }
        }
    }

    public static class Socks4ProxyClientConnectionFactory
    implements ClientConnectionFactory {
        private final ClientConnectionFactory connectionFactory;

        public Socks4ProxyClientConnectionFactory(ClientConnectionFactory clientConnectionFactory) {
            this.connectionFactory = clientConnectionFactory;
        }

        @Override
        public Connection newConnection(EndPoint endPoint, Map<String, Object> map) {
            HttpDestination httpDestination = (HttpDestination)map.get("http.destination");
            Executor executor = httpDestination.getHttpClient().getExecutor();
            Socks4ProxyConnection socks4ProxyConnection = new Socks4ProxyConnection(endPoint, executor, this.connectionFactory, map);
            return this.customize(socks4ProxyConnection, map);
        }
    }
}

