/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpVersion;

public class HttpResponse
implements Response {
    private final HttpFields headers = new HttpFields();
    private final Request request;
    private final List<Response.ResponseListener> listeners;
    private HttpVersion version;
    private int status;
    private String reason;
    private HttpFields trailers;

    public HttpResponse(Request request, List<Response.ResponseListener> list) {
        this.request = request;
        this.listeners = list;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public HttpVersion getVersion() {
        return this.version;
    }

    public HttpResponse version(HttpVersion httpVersion) {
        this.version = httpVersion;
        return this;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public HttpResponse status(int n) {
        this.status = n;
        return this;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public HttpResponse reason(String string) {
        this.reason = string;
        return this;
    }

    @Override
    public HttpFields getHeaders() {
        return this.headers;
    }

    @Override
    public <T extends Response.ResponseListener> List<T> getListeners(Class<T> clazz) {
        ArrayList<Response.ResponseListener> arrayList = new ArrayList<Response.ResponseListener>();
        for (Response.ResponseListener responseListener : this.listeners) {
            if (clazz != null && !clazz.isInstance(responseListener)) continue;
            arrayList.add(responseListener);
        }
        return arrayList;
    }

    public HttpFields getTrailers() {
        return this.trailers;
    }

    public HttpResponse trailer(HttpField httpField) {
        if (this.trailers == null) {
            this.trailers = new HttpFields();
        }
        this.trailers.add(httpField);
        return this;
    }

    @Override
    public boolean abort(Throwable throwable) {
        return this.request.abort(throwable);
    }

    public String toString() {
        return String.format("%s[%s %d %s]@%x", new Object[]{HttpResponse.class.getSimpleName(), this.getVersion(), this.getStatus(), this.getReason(), this.hashCode()});
    }
}

