/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.xpath;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.InvalidXPathException;
import org.dom4j.Node;
import org.dom4j.NodeFilter;
import org.dom4j.XPath;
import org.dom4j.XPathException;
import org.dom4j.xpath.DefaultNamespaceContext;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.VariableContext;
import org.jaxen.dom4j.Dom4jXPath;

public class DefaultXPath
implements XPath,
NodeFilter,
Serializable {
    private String text;
    private org.jaxen.XPath xpath;
    private NamespaceContext namespaceContext;

    public DefaultXPath(String string) throws InvalidXPathException {
        this.text = string;
        this.xpath = DefaultXPath.parse(string);
    }

    public String toString() {
        return "[XPath: " + this.xpath + "]";
    }

    public String getText() {
        return this.text;
    }

    public FunctionContext getFunctionContext() {
        return this.xpath.getFunctionContext();
    }

    public void setFunctionContext(FunctionContext functionContext) {
        this.xpath.setFunctionContext(functionContext);
    }

    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setNamespaceURIs(Map map) {
        this.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(map));
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
        this.xpath.setNamespaceContext(namespaceContext);
    }

    public VariableContext getVariableContext() {
        return this.xpath.getVariableContext();
    }

    public void setVariableContext(VariableContext variableContext) {
        this.xpath.setVariableContext(variableContext);
    }

    public Object evaluate(Object object) {
        try {
            this.setNSContext(object);
            List list = this.xpath.selectNodes(object);
            if (list != null && list.size() == 1) {
                return list.get(0);
            }
            return list;
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return null;
        }
    }

    public Object selectObject(Object object) {
        return this.evaluate(object);
    }

    public List selectNodes(Object object) {
        try {
            this.setNSContext(object);
            return this.xpath.selectNodes(object);
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return Collections.EMPTY_LIST;
        }
    }

    public List selectNodes(Object object, XPath xPath) {
        List list = this.selectNodes(object);
        xPath.sort(list);
        return list;
    }

    public List selectNodes(Object object, XPath xPath, boolean bl) {
        List list = this.selectNodes(object);
        xPath.sort(list, bl);
        return list;
    }

    public Node selectSingleNode(Object object) {
        try {
            this.setNSContext(object);
            Object object2 = this.xpath.selectSingleNode(object);
            if (object2 instanceof Node) {
                return (Node)object2;
            }
            if (object2 == null) {
                return null;
            }
            throw new XPathException("The result of the XPath expression is not a Node. It was: " + object2 + " of type: " + object2.getClass().getName());
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return null;
        }
    }

    public String valueOf(Object object) {
        try {
            this.setNSContext(object);
            return this.xpath.stringValueOf(object);
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return "";
        }
    }

    public Number numberValueOf(Object object) {
        try {
            this.setNSContext(object);
            return this.xpath.numberValueOf(object);
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return null;
        }
    }

    public boolean booleanValueOf(Object object) {
        try {
            this.setNSContext(object);
            return this.xpath.booleanValueOf(object);
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return false;
        }
    }

    public void sort(List list) {
        this.sort(list, false);
    }

    public void sort(List list, boolean bl) {
        if (list != null && !list.isEmpty()) {
            int n = list.size();
            HashMap<Node, Object> hashMap = new HashMap<Node, Object>(n);
            for (int i = 0; i < n; ++i) {
                Object e = list.get(i);
                if (!(e instanceof Node)) continue;
                Node node = (Node)e;
                Object object = this.getCompareValue(node);
                hashMap.put(node, object);
            }
            this.sort(list, hashMap);
            if (bl) {
                this.removeDuplicates(list, hashMap);
            }
        }
    }

    public boolean matches(Node node) {
        try {
            this.setNSContext(node);
            List list = this.xpath.selectNodes((Object)node);
            if (list != null && list.size() > 0) {
                Object e = list.get(0);
                if (e instanceof Boolean) {
                    return (Boolean)e;
                }
                return list.contains(node);
            }
            return false;
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return false;
        }
    }

    protected void sort(List list, final Map map) {
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                if ((object = map.get(object)) == (object2 = map.get(object2))) {
                    return 0;
                }
                if (object instanceof Comparable) {
                    Comparable comparable = (Comparable)object;
                    return comparable.compareTo(object2);
                }
                if (object == null) {
                    return 1;
                }
                if (object2 == null) {
                    return -1;
                }
                return object.equals(object2) ? 0 : -1;
            }
        });
    }

    protected void removeDuplicates(List list, Map map) {
        HashSet hashSet = new HashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object v = map.get(e);
            if (hashSet.contains(v)) {
                iterator.remove();
                continue;
            }
            hashSet.add(v);
        }
    }

    protected Object getCompareValue(Node node) {
        return this.valueOf(node);
    }

    protected static org.jaxen.XPath parse(String string) {
        try {
            return new Dom4jXPath(string);
        }
        catch (JaxenException jaxenException) {
            throw new InvalidXPathException(string, jaxenException.getMessage());
        }
        catch (Throwable throwable) {
            throw new InvalidXPathException(string, throwable);
        }
    }

    protected void setNSContext(Object object) {
        if (this.namespaceContext == null) {
            this.xpath.setNamespaceContext((NamespaceContext)DefaultNamespaceContext.create(object));
        }
    }

    protected void handleJaxenException(JaxenException jaxenException) throws XPathException {
        throw new XPathException(this.text, (Exception)((Object)jaxenException));
    }
}

