/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.ElementHandler;
import org.dom4j.io.DispatchHandler;
import org.dom4j.io.SAXContentHandler;
import org.dom4j.io.SAXHelper;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXReader {
    private static final String SAX_STRING_INTERNING = "http://xml.org/sax/features/string-interning";
    private static final String SAX_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    private static final String SAX_NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final String SAX_DECL_HANDLER = "http://xml.org/sax/properties/declaration-handler";
    private static final String SAX_LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private static final String SAX_LEXICALHANDLER = "http://xml.org/sax/handlers/LexicalHandler";
    private DocumentFactory factory;
    private XMLReader xmlReader;
    private boolean validating;
    private DispatchHandler dispatchHandler;
    private ErrorHandler errorHandler;
    private EntityResolver entityResolver;
    private boolean stringInternEnabled = true;
    private boolean includeInternalDTDDeclarations = false;
    private boolean includeExternalDTDDeclarations = false;
    private boolean mergeAdjacentText = false;
    private boolean stripWhitespaceText = false;
    private boolean ignoreComments = false;
    private String encoding = null;
    private XMLFilter xmlFilter;

    public SAXReader() {
    }

    public SAXReader(boolean bl) {
        this.validating = bl;
    }

    public SAXReader(DocumentFactory documentFactory) {
        this.factory = documentFactory;
    }

    public SAXReader(DocumentFactory documentFactory, boolean bl) {
        this.factory = documentFactory;
        this.validating = bl;
    }

    public SAXReader(XMLReader xMLReader) {
        this.xmlReader = xMLReader;
    }

    public SAXReader(XMLReader xMLReader, boolean bl) {
        this.xmlReader = xMLReader;
        this.validating = bl;
    }

    public SAXReader(String string) throws SAXException {
        if (string != null) {
            this.xmlReader = XMLReaderFactory.createXMLReader(string);
        }
    }

    public SAXReader(String string, boolean bl) throws SAXException {
        if (string != null) {
            this.xmlReader = XMLReaderFactory.createXMLReader(string);
        }
        this.validating = bl;
    }

    public void setProperty(String string, Object object) throws SAXException {
        this.getXMLReader().setProperty(string, object);
    }

    public void setFeature(String string, boolean bl) throws SAXException {
        this.getXMLReader().setFeature(string, bl);
    }

    public Document read(File file) throws DocumentException {
        try {
            String string;
            InputSource inputSource = new InputSource(new FileInputStream(file));
            if (this.encoding != null) {
                inputSource.setEncoding(this.encoding);
            }
            if ((string = file.getAbsolutePath()) != null) {
                StringBuffer stringBuffer = new StringBuffer("file://");
                if (!string.startsWith(File.separator)) {
                    stringBuffer.append("/");
                }
                string = string.replace('\\', '/');
                stringBuffer.append(string);
                inputSource.setSystemId(stringBuffer.toString());
            }
            return this.read(inputSource);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DocumentException(fileNotFoundException.getMessage(), fileNotFoundException);
        }
    }

    public Document read(URL uRL) throws DocumentException {
        String string = uRL.toExternalForm();
        InputSource inputSource = new InputSource(string);
        if (this.encoding != null) {
            inputSource.setEncoding(this.encoding);
        }
        return this.read(inputSource);
    }

    public Document read(String string) throws DocumentException {
        InputSource inputSource = new InputSource(string);
        if (this.encoding != null) {
            inputSource.setEncoding(this.encoding);
        }
        return this.read(inputSource);
    }

    public Document read(InputStream inputStream) throws DocumentException {
        InputSource inputSource = new InputSource(inputStream);
        if (this.encoding != null) {
            inputSource.setEncoding(this.encoding);
        }
        return this.read(inputSource);
    }

    public Document read(Reader reader) throws DocumentException {
        InputSource inputSource = new InputSource(reader);
        if (this.encoding != null) {
            inputSource.setEncoding(this.encoding);
        }
        return this.read(inputSource);
    }

    public Document read(InputStream inputStream, String string) throws DocumentException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        if (this.encoding != null) {
            inputSource.setEncoding(this.encoding);
        }
        return this.read(inputSource);
    }

    public Document read(Reader reader, String string) throws DocumentException {
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string);
        if (this.encoding != null) {
            inputSource.setEncoding(this.encoding);
        }
        return this.read(inputSource);
    }

    public Document read(InputSource inputSource) throws DocumentException {
        try {
            XMLReader xMLReader = this.getXMLReader();
            xMLReader = this.installXMLFilter(xMLReader);
            EntityResolver entityResolver = this.entityResolver;
            if (entityResolver == null) {
                this.entityResolver = entityResolver = this.createDefaultEntityResolver(inputSource.getSystemId());
            }
            xMLReader.setEntityResolver(entityResolver);
            SAXContentHandler sAXContentHandler = this.createContentHandler(xMLReader);
            sAXContentHandler.setEntityResolver(entityResolver);
            sAXContentHandler.setInputSource(inputSource);
            boolean bl = this.isIncludeInternalDTDDeclarations();
            boolean bl2 = this.isIncludeExternalDTDDeclarations();
            sAXContentHandler.setIncludeInternalDTDDeclarations(bl);
            sAXContentHandler.setIncludeExternalDTDDeclarations(bl2);
            sAXContentHandler.setMergeAdjacentText(this.isMergeAdjacentText());
            sAXContentHandler.setStripWhitespaceText(this.isStripWhitespaceText());
            sAXContentHandler.setIgnoreComments(this.isIgnoreComments());
            xMLReader.setContentHandler(sAXContentHandler);
            this.configureReader(xMLReader, sAXContentHandler);
            xMLReader.parse(inputSource);
            return sAXContentHandler.getDocument();
        }
        catch (Exception exception) {
            if (exception instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)exception;
                String string = sAXParseException.getSystemId();
                if (string == null) {
                    string = "";
                }
                String string2 = "Error on line " + sAXParseException.getLineNumber() + " of document " + string + " : " + sAXParseException.getMessage();
                throw new DocumentException(string2, exception);
            }
            throw new DocumentException(exception.getMessage(), exception);
        }
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidation(boolean bl) {
        this.validating = bl;
    }

    public boolean isIncludeInternalDTDDeclarations() {
        return this.includeInternalDTDDeclarations;
    }

    public void setIncludeInternalDTDDeclarations(boolean bl) {
        this.includeInternalDTDDeclarations = bl;
    }

    public boolean isIncludeExternalDTDDeclarations() {
        return this.includeExternalDTDDeclarations;
    }

    public void setIncludeExternalDTDDeclarations(boolean bl) {
        this.includeExternalDTDDeclarations = bl;
    }

    public boolean isStringInternEnabled() {
        return this.stringInternEnabled;
    }

    public void setStringInternEnabled(boolean bl) {
        this.stringInternEnabled = bl;
    }

    public boolean isMergeAdjacentText() {
        return this.mergeAdjacentText;
    }

    public void setMergeAdjacentText(boolean bl) {
        this.mergeAdjacentText = bl;
    }

    public boolean isStripWhitespaceText() {
        return this.stripWhitespaceText;
    }

    public void setStripWhitespaceText(boolean bl) {
        this.stripWhitespaceText = bl;
    }

    public boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    public void setIgnoreComments(boolean bl) {
        this.ignoreComments = bl;
    }

    public DocumentFactory getDocumentFactory() {
        if (this.factory == null) {
            this.factory = DocumentFactory.getInstance();
        }
        return this.factory;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.factory = documentFactory;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public XMLReader getXMLReader() throws SAXException {
        if (this.xmlReader == null) {
            this.xmlReader = this.createXMLReader();
        }
        return this.xmlReader;
    }

    public void setXMLReader(XMLReader xMLReader) {
        this.xmlReader = xMLReader;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setXMLReaderClassName(String string) throws SAXException {
        this.setXMLReader(XMLReaderFactory.createXMLReader(string));
    }

    public void addHandler(String string, ElementHandler elementHandler) {
        this.getDispatchHandler().addHandler(string, elementHandler);
    }

    public void removeHandler(String string) {
        this.getDispatchHandler().removeHandler(string);
    }

    public void setDefaultHandler(ElementHandler elementHandler) {
        this.getDispatchHandler().setDefaultHandler(elementHandler);
    }

    public void resetHandlers() {
        this.getDispatchHandler().resetHandlers();
    }

    public XMLFilter getXMLFilter() {
        return this.xmlFilter;
    }

    public void setXMLFilter(XMLFilter xMLFilter) {
        this.xmlFilter = xMLFilter;
    }

    protected XMLReader installXMLFilter(XMLReader xMLReader) {
        XMLFilter xMLFilter = this.getXMLFilter();
        if (xMLFilter != null) {
            XMLReader xMLReader2;
            XMLFilter xMLFilter2 = xMLFilter;
            while ((xMLReader2 = xMLFilter2.getParent()) instanceof XMLFilter) {
                xMLFilter2 = (XMLFilter)xMLReader2;
            }
            xMLFilter2.setParent(xMLReader);
            return xMLFilter;
        }
        return xMLReader;
    }

    protected DispatchHandler getDispatchHandler() {
        if (this.dispatchHandler == null) {
            this.dispatchHandler = new DispatchHandler();
        }
        return this.dispatchHandler;
    }

    protected void setDispatchHandler(DispatchHandler dispatchHandler) {
        this.dispatchHandler = dispatchHandler;
    }

    protected XMLReader createXMLReader() throws SAXException {
        return SAXHelper.createXMLReader(this.isValidating());
    }

    protected void configureReader(XMLReader xMLReader, DefaultHandler defaultHandler) throws DocumentException {
        block5: {
            SAXHelper.setParserProperty(xMLReader, SAX_LEXICALHANDLER, defaultHandler);
            SAXHelper.setParserProperty(xMLReader, SAX_LEXICAL_HANDLER, defaultHandler);
            if (this.includeInternalDTDDeclarations || this.includeExternalDTDDeclarations) {
                SAXHelper.setParserProperty(xMLReader, SAX_DECL_HANDLER, defaultHandler);
            }
            SAXHelper.setParserFeature(xMLReader, SAX_NAMESPACES, true);
            SAXHelper.setParserFeature(xMLReader, SAX_NAMESPACE_PREFIXES, false);
            SAXHelper.setParserFeature(xMLReader, SAX_STRING_INTERNING, this.isStringInternEnabled());
            SAXHelper.setParserFeature(xMLReader, "http://xml.org/sax/features/use-locator2", true);
            try {
                xMLReader.setFeature("http://xml.org/sax/features/validation", this.isValidating());
                if (this.errorHandler != null) {
                    xMLReader.setErrorHandler(this.errorHandler);
                } else {
                    xMLReader.setErrorHandler(defaultHandler);
                }
            }
            catch (Exception exception) {
                if (!this.isValidating()) break block5;
                throw new DocumentException("Validation not supported for XMLReader: " + xMLReader, exception);
            }
        }
    }

    protected SAXContentHandler createContentHandler(XMLReader xMLReader) {
        return new SAXContentHandler(this.getDocumentFactory(), this.dispatchHandler);
    }

    protected EntityResolver createDefaultEntityResolver(String string) {
        int n;
        String string2 = null;
        if (string != null && string.length() > 0 && (n = string.lastIndexOf(47)) > 0) {
            string2 = string.substring(0, n + 1);
        }
        return new SAXEntityResolver(string2);
    }

    protected static class SAXEntityResolver
    implements EntityResolver,
    Serializable {
        protected String uriPrefix;

        public SAXEntityResolver(String string) {
            this.uriPrefix = string;
        }

        public InputSource resolveEntity(String string, String string2) {
            if (string2 != null && string2.length() > 0 && this.uriPrefix != null && string2.indexOf(58) <= 0) {
                string2 = this.uriPrefix + string2;
            }
            return new InputSource(string2);
        }
    }
}

