/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.io.ElementModifier;
import org.dom4j.io.PruningDispatchHandler;
import org.dom4j.io.SAXHelper;
import org.dom4j.io.SAXModifyElementHandler;
import org.dom4j.io.SAXModifyException;
import org.dom4j.io.SAXModifyReader;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXModifier {
    private XMLWriter xmlWriter;
    private XMLReader xmlReader;
    private boolean pruneElements;
    private SAXModifyReader modifyReader;
    private HashMap modifiers = new HashMap();

    public SAXModifier() {
    }

    public SAXModifier(boolean bl) {
        this.pruneElements = bl;
    }

    public SAXModifier(XMLReader xMLReader) {
        this.xmlReader = xMLReader;
    }

    public SAXModifier(XMLReader xMLReader, boolean bl) {
        this.xmlReader = xMLReader;
    }

    public Document modify(File file) throws DocumentException {
        try {
            return this.installModifyReader().read(file);
        }
        catch (SAXModifyException sAXModifyException) {
            Throwable throwable = sAXModifyException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public Document modify(InputSource inputSource) throws DocumentException {
        try {
            return this.installModifyReader().read(inputSource);
        }
        catch (SAXModifyException sAXModifyException) {
            Throwable throwable = sAXModifyException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public Document modify(InputStream inputStream) throws DocumentException {
        try {
            return this.installModifyReader().read(inputStream);
        }
        catch (SAXModifyException sAXModifyException) {
            Throwable throwable = sAXModifyException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public Document modify(InputStream inputStream, String string) throws DocumentException {
        try {
            return this.installModifyReader().read(inputStream);
        }
        catch (SAXModifyException sAXModifyException) {
            Throwable throwable = sAXModifyException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public Document modify(Reader reader) throws DocumentException {
        try {
            return this.installModifyReader().read(reader);
        }
        catch (SAXModifyException sAXModifyException) {
            Throwable throwable = sAXModifyException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public Document modify(Reader reader, String string) throws DocumentException {
        try {
            return this.installModifyReader().read(reader);
        }
        catch (SAXModifyException sAXModifyException) {
            Throwable throwable = sAXModifyException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public Document modify(URL uRL) throws DocumentException {
        try {
            return this.installModifyReader().read(uRL);
        }
        catch (SAXModifyException sAXModifyException) {
            Throwable throwable = sAXModifyException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public Document modify(String string) throws DocumentException {
        try {
            return this.installModifyReader().read(string);
        }
        catch (SAXModifyException sAXModifyException) {
            Throwable throwable = sAXModifyException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public void addModifier(String string, ElementModifier elementModifier) {
        this.modifiers.put(string, elementModifier);
    }

    public void resetModifiers() {
        this.modifiers.clear();
        this.getSAXModifyReader().resetHandlers();
    }

    public void removeModifier(String string) {
        this.modifiers.remove(string);
        this.getSAXModifyReader().removeHandler(string);
    }

    public DocumentFactory getDocumentFactory() {
        return this.getSAXModifyReader().getDocumentFactory();
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.getSAXModifyReader().setDocumentFactory(documentFactory);
    }

    public XMLWriter getXMLWriter() {
        return this.xmlWriter;
    }

    public void setXMLWriter(XMLWriter xMLWriter) {
        this.xmlWriter = xMLWriter;
    }

    public boolean isPruneElements() {
        return this.pruneElements;
    }

    private SAXReader installModifyReader() throws DocumentException {
        try {
            SAXModifyReader sAXModifyReader = this.getSAXModifyReader();
            if (this.isPruneElements()) {
                this.modifyReader.setDispatchHandler(new PruningDispatchHandler());
            }
            sAXModifyReader.resetHandlers();
            Iterator iterator = this.modifiers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SAXModifyElementHandler sAXModifyElementHandler = new SAXModifyElementHandler((ElementModifier)entry.getValue());
                sAXModifyReader.addHandler((String)entry.getKey(), sAXModifyElementHandler);
            }
            sAXModifyReader.setXMLWriter(this.getXMLWriter());
            sAXModifyReader.setXMLReader(this.getXMLReader());
            return sAXModifyReader;
        }
        catch (SAXException sAXException) {
            throw new DocumentException(sAXException.getMessage(), sAXException);
        }
    }

    private XMLReader getXMLReader() throws SAXException {
        if (this.xmlReader == null) {
            this.xmlReader = SAXHelper.createXMLReader(false);
        }
        return this.xmlReader;
    }

    private SAXModifyReader getSAXModifyReader() {
        if (this.modifyReader == null) {
            this.modifyReader = new SAXModifyReader();
        }
        return this.modifyReader;
    }
}

