/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.dom;

import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.DocumentFactory;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.dom.DOMAttributeNodeMap;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.dom.DOMNodeHelper;
import org.dom4j.tree.DefaultElement;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMElement
extends DefaultElement
implements Element {
    private static final DocumentFactory DOCUMENT_FACTORY = DOMDocumentFactory.getInstance();

    public DOMElement(String string) {
        super(string);
    }

    public DOMElement(QName qName) {
        super(qName);
    }

    public DOMElement(QName qName, int n) {
        super(qName, n);
    }

    public DOMElement(String string, Namespace namespace) {
        super(string, namespace);
    }

    public boolean supports(String string, String string2) {
        return DOMNodeHelper.supports(this, string, string2);
    }

    public String getNamespaceURI() {
        return this.getQName().getNamespaceURI();
    }

    public String getPrefix() {
        return this.getQName().getNamespacePrefix();
    }

    public void setPrefix(String string) throws DOMException {
        DOMNodeHelper.setPrefix(this, string);
    }

    public String getLocalName() {
        return this.getQName().getName();
    }

    public String getNodeName() {
        return this.getName();
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
    }

    public Node getParentNode() {
        return DOMNodeHelper.getParentNode(this);
    }

    public NodeList getChildNodes() {
        return DOMNodeHelper.createNodeList(this.content());
    }

    public Node getFirstChild() {
        return DOMNodeHelper.asDOMNode(this.node(0));
    }

    public Node getLastChild() {
        return DOMNodeHelper.asDOMNode(this.node(this.nodeCount() - 1));
    }

    public Node getPreviousSibling() {
        return DOMNodeHelper.getPreviousSibling(this);
    }

    public Node getNextSibling() {
        return DOMNodeHelper.getNextSibling(this);
    }

    public NamedNodeMap getAttributes() {
        return new DOMAttributeNodeMap(this);
    }

    public Document getOwnerDocument() {
        return DOMNodeHelper.getOwnerDocument(this);
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        this.checkNewChildNode(node);
        return DOMNodeHelper.insertBefore(this, node, node2);
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.checkNewChildNode(node);
        return DOMNodeHelper.replaceChild(this, node, node2);
    }

    public Node removeChild(Node node) throws DOMException {
        return DOMNodeHelper.removeChild(this, node);
    }

    public Node appendChild(Node node) throws DOMException {
        this.checkNewChildNode(node);
        return DOMNodeHelper.appendChild(this, node);
    }

    private void checkNewChildNode(Node node) throws DOMException {
        short s = node.getNodeType();
        if (s != 1 && s != 3 && s != 8 && s != 7 && s != 4 && s != 5) {
            throw new DOMException(3, "Given node cannot be a child of element");
        }
    }

    public boolean hasChildNodes() {
        return this.nodeCount() > 0;
    }

    public Node cloneNode(boolean bl) {
        return DOMNodeHelper.cloneNode(this, bl);
    }

    public boolean isSupported(String string, String string2) {
        return DOMNodeHelper.isSupported(this, string, string2);
    }

    public boolean hasAttributes() {
        return DOMNodeHelper.hasAttributes(this);
    }

    public String getTagName() {
        return this.getName();
    }

    public String getAttribute(String string) {
        String string2 = this.attributeValue(string);
        return string2 != null ? string2 : "";
    }

    public void setAttribute(String string, String string2) throws DOMException {
        this.addAttribute(string, string2);
    }

    public void removeAttribute(String string) throws DOMException {
        Attribute attribute = this.attribute(string);
        if (attribute != null) {
            this.remove(attribute);
        }
    }

    public Attr getAttributeNode(String string) {
        return DOMNodeHelper.asDOMAttr(this.attribute(string));
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, "No modification allowed");
        }
        Attribute attribute = this.attribute(attr);
        if (attribute != attr) {
            if (attr.getOwnerElement() != null) {
                throw new DOMException(10, "Attribute is already in use");
            }
            Attribute attribute2 = this.createAttribute(attr);
            if (attribute != null) {
                attribute.detach();
            }
            this.add(attribute2);
        }
        return DOMNodeHelper.asDOMAttr(attribute);
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        Attribute attribute = this.attribute(attr);
        if (attribute != null) {
            attribute.detach();
            return DOMNodeHelper.asDOMAttr(attribute);
        }
        throw new DOMException(8, "No such attribute");
    }

    public String getAttributeNS(String string, String string2) {
        String string3;
        Attribute attribute = this.attribute(string, string2);
        if (attribute != null && (string3 = attribute.getValue()) != null) {
            return string3;
        }
        return "";
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        Attribute attribute = this.attribute(string, string2);
        if (attribute != null) {
            attribute.setValue(string3);
        } else {
            QName qName = this.getQName(string, string2);
            this.addAttribute(qName, string3);
        }
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        Attribute attribute = this.attribute(string, string2);
        if (attribute != null) {
            this.remove(attribute);
        }
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        Attribute attribute = this.attribute(string, string2);
        if (attribute != null) {
            DOMNodeHelper.asDOMAttr(attribute);
        }
        return null;
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        Attribute attribute = this.attribute(attr.getNamespaceURI(), attr.getLocalName());
        if (attribute != null) {
            attribute.setValue(attr.getValue());
        } else {
            attribute = this.createAttribute(attr);
            this.add(attribute);
        }
        return DOMNodeHelper.asDOMAttr(attribute);
    }

    public NodeList getElementsByTagName(String string) {
        ArrayList arrayList = new ArrayList();
        DOMNodeHelper.appendElementsByTagName(arrayList, this, string);
        return DOMNodeHelper.createNodeList(arrayList);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        ArrayList arrayList = new ArrayList();
        DOMNodeHelper.appendElementsByTagNameNS(arrayList, this, string, string2);
        return DOMNodeHelper.createNodeList(arrayList);
    }

    public boolean hasAttribute(String string) {
        return this.attribute(string) != null;
    }

    public boolean hasAttributeNS(String string, String string2) {
        return this.attribute(string, string2) != null;
    }

    protected DocumentFactory getDocumentFactory() {
        DocumentFactory documentFactory = this.getQName().getDocumentFactory();
        return documentFactory != null ? documentFactory : DOCUMENT_FACTORY;
    }

    protected Attribute attribute(Attr attr) {
        return this.attribute(DOCUMENT_FACTORY.createQName(attr.getLocalName(), attr.getPrefix(), attr.getNamespaceURI()));
    }

    protected Attribute attribute(String string, String string2) {
        List list = this.attributeList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Attribute attribute = (Attribute)list.get(i);
            if (!string2.equals(attribute.getName()) || (string != null && string.length() != 0 || attribute.getNamespaceURI() != null && attribute.getNamespaceURI().length() != 0) && (string == null || !string.equals(attribute.getNamespaceURI()))) continue;
            return attribute;
        }
        return null;
    }

    protected Attribute createAttribute(Attr attr) {
        QName qName = null;
        String string = attr.getLocalName();
        if (string != null) {
            String string2 = attr.getPrefix();
            String string3 = attr.getNamespaceURI();
            qName = this.getDocumentFactory().createQName(string, string2, string3);
        } else {
            string = attr.getName();
            qName = this.getDocumentFactory().createQName(string);
        }
        return new DOMAttribute(qName, attr.getValue());
    }

    protected QName getQName(String string, String string2) {
        int n = string2.indexOf(58);
        String string3 = "";
        String string4 = string2;
        if (n >= 0) {
            string3 = string2.substring(0, n);
            string4 = string2.substring(n + 1);
        }
        return this.getDocumentFactory().createQName(string4, string3, string);
    }
}

