/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.DocumentFactory;
import org.dom4j.QName;
import org.dom4j.bean.BeanAttributeList;
import org.dom4j.bean.BeanDocumentFactory;
import org.dom4j.bean.BeanElement;

public class BeanMetaData {
    protected static final Object[] NULL_ARGS = new Object[0];
    private static Map singletonCache = new HashMap();
    private static final DocumentFactory DOCUMENT_FACTORY = BeanDocumentFactory.getInstance();
    private Class beanClass;
    private PropertyDescriptor[] propertyDescriptors;
    private QName[] qNames;
    private Method[] readMethods;
    private Method[] writeMethods;
    private Map nameMap = new HashMap();

    public BeanMetaData(Class clazz) {
        this.beanClass = clazz;
        if (clazz != null) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                this.propertyDescriptors = beanInfo.getPropertyDescriptors();
            }
            catch (IntrospectionException introspectionException) {
                this.handleException(introspectionException);
            }
        }
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = new PropertyDescriptor[0];
        }
        int n = this.propertyDescriptors.length;
        this.qNames = new QName[n];
        this.readMethods = new Method[n];
        this.writeMethods = new Method[n];
        for (int i = 0; i < n; ++i) {
            QName qName;
            PropertyDescriptor propertyDescriptor = this.propertyDescriptors[i];
            String string = propertyDescriptor.getName();
            this.qNames[i] = qName = DOCUMENT_FACTORY.createQName(string);
            this.readMethods[i] = propertyDescriptor.getReadMethod();
            this.writeMethods[i] = propertyDescriptor.getWriteMethod();
            Integer n2 = new Integer(i);
            this.nameMap.put(string, n2);
            this.nameMap.put(qName, n2);
        }
    }

    public static BeanMetaData get(Class clazz) {
        BeanMetaData beanMetaData = (BeanMetaData)singletonCache.get(clazz);
        if (beanMetaData == null) {
            beanMetaData = new BeanMetaData(clazz);
            singletonCache.put(clazz, beanMetaData);
        }
        return beanMetaData;
    }

    public int attributeCount() {
        return this.propertyDescriptors.length;
    }

    public BeanAttributeList createAttributeList(BeanElement beanElement) {
        return new BeanAttributeList(beanElement, this);
    }

    public QName getQName(int n) {
        return this.qNames[n];
    }

    public int getIndex(String string) {
        Integer n = (Integer)this.nameMap.get(string);
        return n != null ? n : -1;
    }

    public int getIndex(QName qName) {
        Integer n = (Integer)this.nameMap.get(qName);
        return n != null ? n : -1;
    }

    public Object getData(int n, Object object) {
        try {
            Method method = this.readMethods[n];
            return method.invoke(object, NULL_ARGS);
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    public void setData(int n, Object object, Object object2) {
        try {
            Method method = this.writeMethods[n];
            Object[] objectArray = new Object[]{object2};
            method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    protected void handleException(Exception exception) {
    }
}

