/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.bean;

import java.util.AbstractList;
import org.dom4j.Attribute;
import org.dom4j.QName;
import org.dom4j.bean.BeanAttribute;
import org.dom4j.bean.BeanElement;
import org.dom4j.bean.BeanMetaData;

public class BeanAttributeList
extends AbstractList {
    private BeanElement parent;
    private BeanMetaData beanMetaData;
    private BeanAttribute[] attributes;

    public BeanAttributeList(BeanElement beanElement, BeanMetaData beanMetaData) {
        this.parent = beanElement;
        this.beanMetaData = beanMetaData;
        this.attributes = new BeanAttribute[beanMetaData.attributeCount()];
    }

    public BeanAttributeList(BeanElement beanElement) {
        this.parent = beanElement;
        Object object = beanElement.getData();
        Class<?> clazz = object != null ? object.getClass() : null;
        this.beanMetaData = BeanMetaData.get(clazz);
        this.attributes = new BeanAttribute[this.beanMetaData.attributeCount()];
    }

    public Attribute attribute(String string) {
        int n = this.beanMetaData.getIndex(string);
        return this.attribute(n);
    }

    public Attribute attribute(QName qName) {
        int n = this.beanMetaData.getIndex(qName);
        return this.attribute(n);
    }

    public BeanAttribute attribute(int n) {
        if (n >= 0 && n <= this.attributes.length) {
            BeanAttribute beanAttribute = this.attributes[n];
            if (beanAttribute == null) {
                this.attributes[n] = beanAttribute = this.createAttribute(this.parent, n);
            }
            return beanAttribute;
        }
        return null;
    }

    public BeanElement getParent() {
        return this.parent;
    }

    public QName getQName(int n) {
        return this.beanMetaData.getQName(n);
    }

    public Object getData(int n) {
        return this.beanMetaData.getData(n, this.parent.getData());
    }

    public void setData(int n, Object object) {
        this.beanMetaData.setData(n, this.parent.getData(), object);
    }

    public int size() {
        return this.attributes.length;
    }

    public Object get(int n) {
        BeanAttribute beanAttribute = this.attributes[n];
        if (beanAttribute == null) {
            this.attributes[n] = beanAttribute = this.createAttribute(this.parent, n);
        }
        return beanAttribute;
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException("add(Object) unsupported");
    }

    public void add(int n, Object object) {
        throw new UnsupportedOperationException("add(int,Object) unsupported");
    }

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException("set(int,Object) unsupported");
    }

    public boolean remove(Object object) {
        return false;
    }

    public Object remove(int n) {
        BeanAttribute beanAttribute = (BeanAttribute)this.get(n);
        String string = beanAttribute.getValue();
        beanAttribute.setValue(null);
        return string;
    }

    public void clear() {
        int n = this.attributes.length;
        for (int i = 0; i < n; ++i) {
            BeanAttribute beanAttribute = this.attributes[i];
            if (beanAttribute == null) continue;
            beanAttribute.setValue(null);
        }
    }

    protected BeanAttribute createAttribute(BeanElement beanElement, int n) {
        return new BeanAttribute(this, n);
    }
}

