/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.FileHeader;
import org.cryptomator.cryptolib.api.FileHeaderCryptor;
import org.cryptomator.cryptolib.common.CipherSupplier;
import org.cryptomator.cryptolib.common.MacSupplier;
import org.cryptomator.cryptolib.v1.FileHeaderImpl;

class FileHeaderCryptorImpl
implements FileHeaderCryptor {
    private final SecretKey headerKey;
    private final SecretKey macKey;
    private final SecureRandom random;

    FileHeaderCryptorImpl(SecretKey secretKey, SecretKey secretKey2, SecureRandom secureRandom) {
        this.headerKey = secretKey;
        this.macKey = secretKey2;
        this.random = secureRandom;
    }

    @Override
    public FileHeader create() {
        byte[] byArray = new byte[16];
        this.random.nextBytes(byArray);
        byte[] byArray2 = new byte[32];
        this.random.nextBytes(byArray2);
        return new FileHeaderImpl(byArray, byArray2);
    }

    @Override
    public int headerSize() {
        return 88;
    }

    @Override
    public ByteBuffer encryptHeader(FileHeader fileHeader) {
        FileHeaderImpl fileHeaderImpl = FileHeaderImpl.cast(fileHeader);
        ByteBuffer byteBuffer = ByteBuffer.allocate(40);
        byteBuffer.putLong(-1L);
        byteBuffer.put(fileHeaderImpl.getPayload().getContentKeyBytes());
        byteBuffer.flip();
        try {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(88);
            byteBuffer2.put(fileHeaderImpl.getNonce());
            Cipher cipher = CipherSupplier.AES_CTR.forEncryption(this.headerKey, new IvParameterSpec(fileHeaderImpl.getNonce()));
            int n = cipher.doFinal(byteBuffer, byteBuffer2);
            assert (n == 40);
            ByteBuffer byteBuffer3 = byteBuffer2.duplicate();
            byteBuffer3.flip();
            Mac mac = MacSupplier.HMAC_SHA256.withKey(this.macKey);
            mac.update(byteBuffer3);
            byteBuffer2.put(mac.doFinal());
            byteBuffer2.flip();
            ByteBuffer byteBuffer4 = byteBuffer2;
            return byteBuffer4;
        }
        catch (ShortBufferException shortBufferException) {
            throw new IllegalStateException("Result buffer too small for encrypted header payload.", shortBufferException);
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new IllegalStateException("Unexpected exception for CTR ciphers.", generalSecurityException);
        }
        finally {
            Arrays.fill(byteBuffer.array(), (byte)0);
        }
    }

    @Override
    public FileHeader decryptHeader(ByteBuffer byteBuffer) throws AuthenticationFailedException {
        if (byteBuffer.remaining() < 88) {
            throw new IllegalArgumentException("Malformed ciphertext header");
        }
        ByteBuffer byteBuffer2 = byteBuffer.asReadOnlyBuffer();
        byte[] byArray = new byte[16];
        byteBuffer2.position(0);
        byteBuffer2.get(byArray);
        byte[] byArray2 = new byte[40];
        byteBuffer2.position(16);
        byteBuffer2.get(byArray2);
        byte[] byArray3 = new byte[32];
        byteBuffer2.position(56);
        byteBuffer2.get(byArray3);
        ByteBuffer byteBuffer3 = byteBuffer2.duplicate();
        byteBuffer3.position(0).limit(56);
        Mac mac = MacSupplier.HMAC_SHA256.withKey(this.macKey);
        mac.update(byteBuffer3);
        byte[] byArray4 = mac.doFinal();
        if (!MessageDigest.isEqual(byArray3, byArray4)) {
            throw new AuthenticationFailedException("Header MAC doesn't match.");
        }
        ByteBuffer byteBuffer4 = ByteBuffer.allocate(40);
        try {
            Cipher cipher = CipherSupplier.AES_CTR.forDecryption(this.headerKey, new IvParameterSpec(byArray));
            int n = cipher.doFinal(ByteBuffer.wrap(byArray2), byteBuffer4);
            assert (n == 40);
            byteBuffer4.position(0);
            long l = byteBuffer4.getLong();
            byteBuffer4.position(8);
            byte[] byArray5 = new byte[32];
            byteBuffer4.get(byArray5);
            FileHeaderImpl fileHeaderImpl = new FileHeaderImpl(byArray, byArray5);
            fileHeaderImpl.setFilesize(l);
            FileHeaderImpl fileHeaderImpl2 = fileHeaderImpl;
            return fileHeaderImpl2;
        }
        catch (ShortBufferException shortBufferException) {
            throw new IllegalStateException("Result buffer too small for decrypted header payload.", shortBufferException);
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new IllegalStateException("Unexpected exception for CTR ciphers.", generalSecurityException);
        }
        finally {
            Arrays.fill(byteBuffer4.array(), (byte)0);
        }
    }
}

