/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileHeader;
import org.cryptomator.cryptolib.common.ByteBuffers;

public class DecryptingReadableByteChannel
implements ReadableByteChannel {
    private final ReadableByteChannel delegate;
    private final Cryptor cryptor;
    private final boolean authenticate;
    private ByteBuffer cleartextChunk;
    private FileHeader header;
    private boolean reachedEof = false;
    private long chunk = 0L;

    public DecryptingReadableByteChannel(ReadableByteChannel readableByteChannel, Cryptor cryptor, boolean bl) {
        this.delegate = readableByteChannel;
        this.cryptor = cryptor;
        this.authenticate = bl;
        this.cleartextChunk = ByteBuffer.allocate(0);
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public synchronized int read(ByteBuffer byteBuffer) throws IOException {
        this.loadHeaderIfNecessary();
        if (this.reachedEof) {
            return -1;
        }
        return this.readInternal(byteBuffer);
    }

    private int readInternal(ByteBuffer byteBuffer) throws IOException {
        assert (this.header != null) : "header must be initialized";
        int n = 0;
        while (byteBuffer.hasRemaining() && !this.reachedEof) {
            if (this.cleartextChunk.hasRemaining() || this.loadNextCleartextChunk()) {
                n += ByteBuffers.copy(this.cleartextChunk, byteBuffer);
                continue;
            }
            assert (this.reachedEof) : "no further cleartext available";
        }
        return n;
    }

    private void loadHeaderIfNecessary() throws IOException {
        if (this.header == null) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.cryptor.fileHeaderCryptor().headerSize());
            int n = this.delegate.read(byteBuffer);
            if (n != byteBuffer.capacity()) {
                throw new IllegalArgumentException("Unable to read header from channel.");
            }
            byteBuffer.flip();
            this.header = this.cryptor.fileHeaderCryptor().decryptHeader(byteBuffer);
        }
    }

    private boolean loadNextCleartextChunk() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.cryptor.fileContentCryptor().ciphertextChunkSize());
        int n = this.delegate.read(byteBuffer);
        if (n == -1) {
            this.reachedEof = true;
            return false;
        }
        byteBuffer.flip();
        this.cleartextChunk = this.cryptor.fileContentCryptor().decryptChunk(byteBuffer, this.chunk++, this.header, this.authenticate);
        return true;
    }
}

