/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import dagger.Module;
import dagger.Provides;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.inject.Qualifier;
import org.cryptomator.cryptolib.common.ReseedingSecureRandom;

@Module
public class SecureRandomModule {
    private final SecureRandom seeder;

    public SecureRandomModule(SecureRandom secureRandom) {
        this.seeder = secureRandom;
    }

    @Provides
    @NativeSecureRandom
    public SecureRandom provideNativeSecureRandom() {
        return this.seeder;
    }

    @Provides
    @FastSecureRandom
    public SecureRandom provideFastSecureRandom(@NativeSecureRandom SecureRandom secureRandom) {
        try {
            return new ReseedingSecureRandom(secureRandom, SecureRandom.getInstance("SHA1PRNG"), 0x40000000L, 55);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("SHA1PRNG must exist in every Java platform.", noSuchAlgorithmException);
        }
    }

    @Qualifier
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FastSecureRandom {
    }

    @Qualifier
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NativeSecureRandom {
    }
}

