/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReseedingSecureRandom
extends SecureRandom {
    private static final Logger LOG = LoggerFactory.getLogger(ReseedingSecureRandom.class);
    private static final Provider PROVIDER = new ReseedingSecureRandomProvider();

    public ReseedingSecureRandom(SecureRandom secureRandom, SecureRandom secureRandom2, long l, int n) {
        super(new ReseedingSecureRandomSpi(secureRandom, secureRandom2, l, n), PROVIDER);
    }

    private static class ReseedingSecureRandomSpi
    extends SecureRandomSpi {
        private final SecureRandom seeder;
        private final SecureRandom csprng;
        private final long reseedAfter;
        private final int seedLength;
        private long counter;

        public ReseedingSecureRandomSpi(SecureRandom secureRandom, SecureRandom secureRandom2, long l, int n) {
            this.seeder = secureRandom;
            this.csprng = secureRandom2;
            this.reseedAfter = l;
            this.seedLength = n;
            this.counter = l;
        }

        @Override
        protected void engineSetSeed(byte[] byArray) {
            this.csprng.setSeed(byArray);
        }

        @Override
        protected void engineNextBytes(byte[] byArray) {
            if (this.counter + (long)byArray.length > this.reseedAfter) {
                this.reseed();
            }
            this.counter += (long)byArray.length;
            this.csprng.nextBytes(byArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected byte[] engineGenerateSeed(int n) {
            try {
                LOG.info("Seeding CSPRNG with {} bytes...", (Object)n);
                byte[] byArray = this.seeder.generateSeed(n);
                return byArray;
            }
            finally {
                LOG.info("Seeded CSPRNG.");
            }
        }

        private void reseed() {
            this.engineSetSeed(this.engineGenerateSeed(this.seedLength));
            this.counter = 0L;
        }
    }

    private static class ReseedingSecureRandomProvider
    extends Provider {
        protected ReseedingSecureRandomProvider() {
            super("ReseedingSecureRandomProvider", 1.0, "Provides ReseedingSecureRandom");
        }
    }
}

