/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class MessageDigestSupplier {
    public static final MessageDigestSupplier SHA1 = new MessageDigestSupplier("SHA-1");
    private final String digestAlgorithm;
    private final ThreadLocal<MessageDigest> threadLocal;

    public MessageDigestSupplier(String string) {
        this.digestAlgorithm = string;
        this.threadLocal = new Provider();
    }

    public MessageDigest get() {
        MessageDigest messageDigest = this.threadLocal.get();
        messageDigest.reset();
        return messageDigest;
    }

    private class Provider
    extends ThreadLocal<MessageDigest> {
        private Provider() {
        }

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance(MessageDigestSupplier.this.digestAlgorithm);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IllegalArgumentException("Invalid digest algorithm.", noSuchAlgorithmException);
            }
        }
    }
}

