/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.migration;

import dagger.internal.MapFactory;
import dagger.internal.MapProviderFactory;
import dagger.internal.Preconditions;
import java.security.SecureRandom;
import java.util.Map;
import javax.inject.Provider;
import org.cryptomator.cryptofs.migration.Migration;
import org.cryptomator.cryptofs.migration.MigrationComponent;
import org.cryptomator.cryptofs.migration.MigrationModule;
import org.cryptomator.cryptofs.migration.MigrationModule_ProvideVersion6MigratorFactory;
import org.cryptomator.cryptofs.migration.Migrators;
import org.cryptomator.cryptofs.migration.Migrators_Factory;
import org.cryptomator.cryptofs.migration.api.Migrator;
import org.cryptomator.cryptofs.migration.v6.Version6Migrator;
import org.cryptomator.cryptofs.migration.v6.Version6Migrator_Factory;
import org.cryptomator.cryptolib.CryptoLibModule;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.common.SecureRandomModule;
import org.cryptomator.cryptolib.common.SecureRandomModule_ProvideFastSecureRandomFactory;
import org.cryptomator.cryptolib.common.SecureRandomModule_ProvideNativeSecureRandomFactory;
import org.cryptomator.cryptolib.v1.Version1CryptorModule;
import org.cryptomator.cryptolib.v1.Version1CryptorModule_ProvideCryptorProviderFactory;

public final class DaggerMigrationComponent
implements MigrationComponent {
    private Provider<SecureRandom> provideNativeSecureRandomProvider;
    private Provider<SecureRandom> provideFastSecureRandomProvider;
    private Provider<CryptorProvider> provideCryptorProvider;
    private Provider<Version6Migrator> version6MigratorProvider;
    private Provider<Migrator> provideVersion6MigratorProvider;
    private Provider<Map<Migration, Provider<Migrator>>> mapOfMigrationAndProviderOfMigratorProvider;
    private Provider<Map<Migration, Migrator>> mapOfMigrationAndMigratorProvider;
    private Provider<Migrators> migratorsProvider;

    private DaggerMigrationComponent(Builder builder) {
        assert (builder != null);
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private void initialize(Builder builder) {
        this.provideNativeSecureRandomProvider = SecureRandomModule_ProvideNativeSecureRandomFactory.create(builder.secureRandomModule);
        this.provideFastSecureRandomProvider = SecureRandomModule_ProvideFastSecureRandomFactory.create(builder.secureRandomModule, this.provideNativeSecureRandomProvider);
        this.provideCryptorProvider = Version1CryptorModule_ProvideCryptorProviderFactory.create(builder.version1CryptorModule, this.provideFastSecureRandomProvider);
        this.version6MigratorProvider = Version6Migrator_Factory.create(this.provideCryptorProvider);
        this.provideVersion6MigratorProvider = MigrationModule_ProvideVersion6MigratorFactory.create(builder.migrationModule, this.version6MigratorProvider);
        this.mapOfMigrationAndProviderOfMigratorProvider = MapProviderFactory.builder(1).put(Migration.FIVE_TO_SIX, this.provideVersion6MigratorProvider).build();
        this.mapOfMigrationAndMigratorProvider = MapFactory.create(this.mapOfMigrationAndProviderOfMigratorProvider);
        this.migratorsProvider = Migrators_Factory.create(this.mapOfMigrationAndMigratorProvider);
    }

    @Override
    public Migrators migrators() {
        return new Migrators(this.mapOfMigrationAndMigratorProvider.get());
    }

    public static final class Builder {
        private SecureRandomModule secureRandomModule;
        private Version1CryptorModule version1CryptorModule;
        private MigrationModule migrationModule;

        private Builder() {
        }

        public MigrationComponent build() {
            if (this.secureRandomModule == null) {
                throw new IllegalStateException(SecureRandomModule.class.getCanonicalName() + " must be set");
            }
            if (this.version1CryptorModule == null) {
                this.version1CryptorModule = new Version1CryptorModule();
            }
            if (this.migrationModule == null) {
                this.migrationModule = new MigrationModule();
            }
            return new DaggerMigrationComponent(this);
        }

        public Builder migrationModule(MigrationModule migrationModule) {
            this.migrationModule = Preconditions.checkNotNull(migrationModule);
            return this;
        }

        @Deprecated
        public Builder cryptoLibModule(CryptoLibModule cryptoLibModule) {
            Preconditions.checkNotNull(cryptoLibModule);
            return this;
        }

        public Builder version1CryptorModule(Version1CryptorModule version1CryptorModule) {
            this.version1CryptorModule = Preconditions.checkNotNull(version1CryptorModule);
            return this;
        }

        public Builder secureRandomModule(SecureRandomModule secureRandomModule) {
            this.secureRandomModule = Preconditions.checkNotNull(secureRandomModule);
            return this;
        }
    }
}

