/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.google.common.base.Throwables;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Supplier;
import org.cryptomator.cryptofs.RunnableThrowingException;
import org.cryptomator.cryptofs.SupplierThrowingException;

class UncheckedThrows {
    private static final ThreadLocal<Deque<Class<?>>> ALLOWED_TO_BE_THROWN_UNCHECKED = ThreadLocal.withInitial(LinkedList::new);

    UncheckedThrows() {
    }

    public static <E extends Exception> UncheckedThrowsAllowanceWithoutAction<E> allowUncheckedThrowsOf(final Class<E> clazz) {
        return new UncheckedThrowsAllowanceWithoutAction<E>(){

            @Override
            public <T> T from(Supplier<T> supplier) throws Exception {
                Deque deque = (Deque)ALLOWED_TO_BE_THROWN_UNCHECKED.get();
                try {
                    deque.addFirst(clazz);
                    T t = supplier.get();
                    return t;
                }
                catch (ExceptionThrownUnchecked exceptionThrownUnchecked) {
                    Throwables.throwIfInstanceOf(exceptionThrownUnchecked.getCause(), clazz);
                    throw exceptionThrownUnchecked;
                }
                finally {
                    deque.removeFirst();
                    if (deque.isEmpty()) {
                        ALLOWED_TO_BE_THROWN_UNCHECKED.remove();
                    }
                }
            }
        };
    }

    public static <E extends Exception> RethrowUncheckedWithoutAction<E> rethrowUnchecked(Class<E> clazz) {
        UncheckedThrows.assertUncheckdThrowsAllowed(clazz);
        return new RethrowUncheckedWithoutAction<E>(){

            @Override
            public <T> T from(SupplierThrowingException<T, E> supplierThrowingException) {
                try {
                    return supplierThrowingException.get();
                }
                catch (Exception exception) {
                    Throwables.throwIfUnchecked(exception);
                    throw new ExceptionThrownUnchecked(exception);
                }
            }
        };
    }

    private static void assertUncheckdThrowsAllowed(Class<? extends Exception> clazz) {
        Deque<Class<?>> deque = ALLOWED_TO_BE_THROWN_UNCHECKED.get();
        try {
            if (!deque.stream().anyMatch(clazz2 -> clazz2.isAssignableFrom(clazz))) {
                throw new IllegalStateException(String.format("Unchecked throws of %s not allowed for the current thread", clazz.getName()));
            }
        }
        finally {
            if (deque.isEmpty()) {
                ALLOWED_TO_BE_THROWN_UNCHECKED.remove();
            }
        }
    }

    public static class ExceptionThrownUnchecked
    extends RuntimeException {
        private ExceptionThrownUnchecked(Exception exception) {
            super(exception);
        }
    }

    public static interface UncheckedThrowsAllowanceWithoutAction<E extends Exception> {
        public <T> T from(Supplier<T> var1) throws E;

        default public void from(Runnable runnable) throws E {
            this.from(() -> {
                runnable.run();
                return null;
            });
        }
    }

    public static interface RethrowUncheckedWithoutAction<E extends Exception> {
        public <T> T from(SupplierThrowingException<T, E> var1);

        default public void from(RunnableThrowingException<E> runnableThrowingException) {
            this.from(() -> {
                runnableThrowingException.run();
                return null;
            });
        }
    }
}

