/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.cryptomator.cryptofs.DirectoryIdLoader;
import org.cryptomator.cryptofs.PerFileSystem;

@PerFileSystem
class DirectoryIdProvider {
    private static final int MAX_CACHE_SIZE = 5000;
    private final LoadingCache<Path, String> ids;

    @Inject
    public DirectoryIdProvider(DirectoryIdLoader directoryIdLoader) {
        this.ids = CacheBuilder.newBuilder().maximumSize(5000L).build(directoryIdLoader);
    }

    public String load(Path path) throws IOException {
        try {
            return this.ids.get(path);
        }
        catch (ExecutionException executionException) {
            throw new IOException("Failed to load contents of directory file at path " + path, executionException);
        }
    }

    public void delete(Path path) {
        this.ids.invalidate(path);
    }

    public void move(Path path, Path path2) {
        String string = (String)this.ids.getIfPresent(path);
        if (string != null) {
            this.ids.put(path2, string);
            this.ids.invalidate(path);
        }
    }
}

