/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import dagger.Module;
import dagger.Provides;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.PathToVault;
import org.cryptomator.cryptofs.PerFileSystem;
import org.cryptomator.cryptofs.UncheckedThrows;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.KeyFile;

@Module
class CryptoFileSystemModule {
    private final Path pathToVault;
    private final CryptoFileSystemProperties cryptoFileSystemProperties;

    private CryptoFileSystemModule(Builder builder) {
        this.pathToVault = builder.pathToVault;
        this.cryptoFileSystemProperties = builder.cryptoFileSystemProperties;
    }

    @Provides
    @PerFileSystem
    public Cryptor provideCryptor(CryptorProvider cryptorProvider, @PathToVault Path path, CryptoFileSystemProperties cryptoFileSystemProperties) {
        return UncheckedThrows.rethrowUnchecked(IOException.class).from(() -> {
            Path path2 = path.resolve(cryptoFileSystemProperties.masterkeyFilename());
            Path path3 = path.resolve(cryptoFileSystemProperties.masterkeyFilename() + ".bkup");
            assert (Files.exists(path2, new LinkOption[0]));
            byte[] byArray = Files.readAllBytes(path2);
            Cryptor cryptor = cryptorProvider.createFromKeyFile(KeyFile.parse(byArray), cryptoFileSystemProperties.passphrase(), cryptoFileSystemProperties.pepper(), 6);
            Files.copy(path2, path3, StandardCopyOption.REPLACE_EXISTING);
            return cryptor;
        });
    }

    @Provides
    @PathToVault
    @PerFileSystem
    public Path providePathToVault() {
        return this.pathToVault;
    }

    @Provides
    @PerFileSystem
    public CryptoFileSystemProperties provideCryptoFileSystemProperties() {
        return this.cryptoFileSystemProperties;
    }

    public static Builder cryptoFileSystemModule() {
        return new Builder();
    }

    public static class Builder {
        private Path pathToVault;
        private CryptoFileSystemProperties cryptoFileSystemProperties;

        private Builder() {
        }

        public Builder withPathToVault(Path path) {
            this.pathToVault = path;
            return this;
        }

        public Builder withCryptoFileSystemProperties(CryptoFileSystemProperties cryptoFileSystemProperties) {
            this.cryptoFileSystemProperties = cryptoFileSystemProperties;
            return this;
        }

        public CryptoFileSystemModule build() {
            this.validate();
            return new CryptoFileSystemModule(this);
        }

        private void validate() {
            if (this.pathToVault == null) {
                throw new IllegalStateException("pathToVault must be set");
            }
            if (this.cryptoFileSystemProperties == null) {
                throw new IllegalStateException("cryptoFileSystemProperties must be set");
            }
        }
    }
}

