/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoBasicFileAttributeView;
import org.cryptomator.cryptofs.CryptoDosFileAttributeView;
import org.cryptomator.cryptofs.CryptoFileAttributeProvider;
import org.cryptomator.cryptofs.CryptoFileOwnerAttributeView;
import org.cryptomator.cryptofs.CryptoPosixFileAttributeView;
import org.cryptomator.cryptofs.PerFileSystem;
import org.cryptomator.cryptofs.UnsupportedFileAttributeViewException;

@PerFileSystem
class CryptoFileAttributeViewProvider {
    private final Map<Class<? extends FileAttributeView>, FileAttributeViewProvider<? extends FileAttributeView>> fileAttributeViewProviders = new HashMap<Class<? extends FileAttributeView>, FileAttributeViewProvider<? extends FileAttributeView>>();
    private final CryptoFileAttributeProvider fileAttributeProvider;

    @Inject
    public CryptoFileAttributeViewProvider(CryptoFileAttributeProvider cryptoFileAttributeProvider2) {
        this.fileAttributeViewProviders.put(BasicFileAttributeView.class, CryptoBasicFileAttributeView::new);
        this.fileAttributeViewProviders.put(PosixFileAttributeView.class, CryptoPosixFileAttributeView::new);
        this.fileAttributeViewProviders.put(FileOwnerAttributeView.class, (path, cryptoFileAttributeProvider) -> new CryptoFileOwnerAttributeView(path));
        this.fileAttributeViewProviders.put(DosFileAttributeView.class, CryptoDosFileAttributeView::new);
        this.fileAttributeProvider = cryptoFileAttributeProvider2;
    }

    public <A extends FileAttributeView> A getAttributeView(Path path, Class<A> clazz) {
        if (this.fileAttributeViewProviders.containsKey(clazz)) {
            FileAttributeViewProvider<? extends FileAttributeView> fileAttributeViewProvider = this.fileAttributeViewProviders.get(clazz);
            try {
                return (A)fileAttributeViewProvider.provide(path, this.fileAttributeProvider);
            }
            catch (UnsupportedFileAttributeViewException unsupportedFileAttributeViewException) {
                return null;
            }
        }
        return null;
    }

    Set<Class<? extends FileAttributeView>> knownFileAttributeViewTypes() {
        return Collections.unmodifiableSet(this.fileAttributeViewProviders.keySet());
    }

    @FunctionalInterface
    private static interface FileAttributeViewProvider<A extends FileAttributeView> {
        public A provide(Path var1, CryptoFileAttributeProvider var2) throws UnsupportedFileAttributeViewException;
    }
}

