/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedClientIF;
import net.spy.memcached.OperationTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheEntrySerializer;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.HttpCacheUpdateCallback;
import org.apache.http.client.cache.HttpCacheUpdateException;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.memcached.KeyHashingScheme;
import org.apache.http.impl.client.cache.memcached.MemcachedCacheEntry;
import org.apache.http.impl.client.cache.memcached.MemcachedCacheEntryFactory;
import org.apache.http.impl.client.cache.memcached.MemcachedCacheEntryFactoryImpl;
import org.apache.http.impl.client.cache.memcached.MemcachedKeyHashingException;
import org.apache.http.impl.client.cache.memcached.MemcachedOperationTimeoutException;
import org.apache.http.impl.client.cache.memcached.MemcachedSerializationException;
import org.apache.http.impl.client.cache.memcached.SHA256KeyHashingScheme;

public class MemcachedHttpCacheStorage
implements HttpCacheStorage {
    private static final Log log = LogFactory.getLog(MemcachedHttpCacheStorage.class);
    private final MemcachedClientIF client;
    private final KeyHashingScheme keyHashingScheme;
    private final MemcachedCacheEntryFactory memcachedCacheEntryFactory;
    private final int maxUpdateRetries;

    public MemcachedHttpCacheStorage(InetSocketAddress inetSocketAddress) throws IOException {
        this((MemcachedClientIF)new MemcachedClient(new InetSocketAddress[]{inetSocketAddress}));
    }

    public MemcachedHttpCacheStorage(MemcachedClientIF memcachedClientIF) {
        this(memcachedClientIF, CacheConfig.DEFAULT, new MemcachedCacheEntryFactoryImpl(), new SHA256KeyHashingScheme());
    }

    @Deprecated
    public MemcachedHttpCacheStorage(MemcachedClientIF memcachedClientIF, CacheConfig cacheConfig, HttpCacheEntrySerializer httpCacheEntrySerializer) {
        this(memcachedClientIF, cacheConfig, new MemcachedCacheEntryFactoryImpl(), new SHA256KeyHashingScheme());
    }

    public MemcachedHttpCacheStorage(MemcachedClientIF memcachedClientIF, CacheConfig cacheConfig, MemcachedCacheEntryFactory memcachedCacheEntryFactory, KeyHashingScheme keyHashingScheme) {
        this.client = memcachedClientIF;
        this.maxUpdateRetries = cacheConfig.getMaxUpdateRetries();
        this.memcachedCacheEntryFactory = memcachedCacheEntryFactory;
        this.keyHashingScheme = keyHashingScheme;
    }

    @Override
    public void putEntry(String string, HttpCacheEntry httpCacheEntry) throws IOException {
        byte[] byArray = this.serializeEntry(string, httpCacheEntry);
        String string2 = this.getCacheKey(string);
        if (string2 == null) {
            return;
        }
        try {
            this.client.set(string2, 0, (Object)byArray);
        }
        catch (OperationTimeoutException operationTimeoutException) {
            throw new MemcachedOperationTimeoutException(operationTimeoutException);
        }
    }

    private String getCacheKey(String string) {
        try {
            return this.keyHashingScheme.hash(string);
        }
        catch (MemcachedKeyHashingException memcachedKeyHashingException) {
            return null;
        }
    }

    private byte[] serializeEntry(String string, HttpCacheEntry httpCacheEntry) throws IOException {
        MemcachedCacheEntry memcachedCacheEntry = this.memcachedCacheEntryFactory.getMemcachedCacheEntry(string, httpCacheEntry);
        try {
            return memcachedCacheEntry.toByteArray();
        }
        catch (MemcachedSerializationException memcachedSerializationException) {
            IOException iOException = new IOException();
            iOException.initCause(memcachedSerializationException);
            throw iOException;
        }
    }

    private byte[] convertToByteArray(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof byte[])) {
            log.warn("got a non-bytearray back from memcached: " + object);
            return null;
        }
        return (byte[])object;
    }

    private MemcachedCacheEntry reconstituteEntry(Object object) {
        byte[] byArray = this.convertToByteArray(object);
        if (byArray == null) {
            return null;
        }
        MemcachedCacheEntry memcachedCacheEntry = this.memcachedCacheEntryFactory.getUnsetCacheEntry();
        try {
            memcachedCacheEntry.set(byArray);
        }
        catch (MemcachedSerializationException memcachedSerializationException) {
            return null;
        }
        return memcachedCacheEntry;
    }

    @Override
    public HttpCacheEntry getEntry(String string) throws IOException {
        String string2 = this.getCacheKey(string);
        if (string2 == null) {
            return null;
        }
        try {
            MemcachedCacheEntry memcachedCacheEntry = this.reconstituteEntry(this.client.get(string2));
            if (memcachedCacheEntry == null || !string.equals(memcachedCacheEntry.getStorageKey())) {
                return null;
            }
            return memcachedCacheEntry.getHttpCacheEntry();
        }
        catch (OperationTimeoutException operationTimeoutException) {
            throw new MemcachedOperationTimeoutException(operationTimeoutException);
        }
    }

    @Override
    public void removeEntry(String string) throws IOException {
        String string2 = this.getCacheKey(string);
        if (string2 == null) {
            return;
        }
        try {
            this.client.delete(string2);
        }
        catch (OperationTimeoutException operationTimeoutException) {
            throw new MemcachedOperationTimeoutException(operationTimeoutException);
        }
    }

    @Override
    public void updateEntry(String string, HttpCacheUpdateCallback httpCacheUpdateCallback) throws HttpCacheUpdateException, IOException {
        int n = 0;
        String string2 = this.getCacheKey(string);
        if (string2 == null) {
            throw new HttpCacheUpdateException("couldn't generate cache key");
        }
        do {
            try {
                MemcachedCacheEntry memcachedCacheEntry;
                CASValue cASValue = this.client.gets(string2);
                MemcachedCacheEntry memcachedCacheEntry2 = memcachedCacheEntry = cASValue == null ? null : this.reconstituteEntry(cASValue.getValue());
                if (memcachedCacheEntry != null && !string.equals(memcachedCacheEntry.getStorageKey())) {
                    memcachedCacheEntry = null;
                }
                HttpCacheEntry httpCacheEntry = memcachedCacheEntry == null ? null : memcachedCacheEntry.getHttpCacheEntry();
                HttpCacheEntry httpCacheEntry2 = httpCacheUpdateCallback.update(httpCacheEntry);
                if (httpCacheEntry == null) {
                    this.putEntry(string, httpCacheEntry2);
                    return;
                }
                byte[] byArray = this.serializeEntry(string, httpCacheEntry2);
                CASResponse cASResponse = this.client.cas(string2, cASValue.getCas(), (Object)byArray);
                if (cASResponse == CASResponse.OK) {
                    return;
                }
            }
            catch (OperationTimeoutException operationTimeoutException) {
                throw new MemcachedOperationTimeoutException(operationTimeoutException);
            }
        } while (++n <= this.maxUpdateRetries);
        throw new HttpCacheUpdateException("Failed to update");
    }
}

