/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.apache.http.HttpEntity;

class IOUtils {
    IOUtils() {
    }

    static void consume(HttpEntity httpEntity) throws IOException {
        InputStream inputStream;
        if (httpEntity == null) {
            return;
        }
        if (httpEntity.isStreaming() && (inputStream = httpEntity.getContent()) != null) {
            inputStream.close();
        }
    }

    static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    static void closeSilently(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void copyAndClose(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            IOUtils.copy(inputStream, outputStream);
            inputStream.close();
            outputStream.close();
        }
        catch (IOException iOException) {
            IOUtils.closeSilently(inputStream);
            IOUtils.closeSilently(outputStream);
            throw iOException;
        }
    }

    static void copyFile(File file, File file2) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        RandomAccessFile randomAccessFile2 = new RandomAccessFile(file2, "rw");
        try {
            FileChannel fileChannel = randomAccessFile.getChannel();
            FileChannel fileChannel2 = randomAccessFile2.getChannel();
            try {
                fileChannel.transferTo(0L, randomAccessFile.length(), fileChannel2);
                fileChannel.close();
                fileChannel2.close();
            }
            catch (IOException iOException) {
                IOUtils.closeSilently(fileChannel);
                IOUtils.closeSilently(fileChannel2);
                throw iOException;
            }
            randomAccessFile.close();
            randomAccessFile2.close();
        }
        catch (IOException iOException) {
            IOUtils.closeSilently(randomAccessFile);
            IOUtils.closeSilently(randomAccessFile2);
            throw iOException;
        }
    }
}

