/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheInvalidator;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.HttpCacheUpdateCallback;
import org.apache.http.client.cache.HttpCacheUpdateException;
import org.apache.http.client.cache.Resource;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.cache.BasicHttpCacheStorage;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CacheEntryUpdater;
import org.apache.http.impl.client.cache.CacheInvalidator;
import org.apache.http.impl.client.cache.CacheKeyGenerator;
import org.apache.http.impl.client.cache.CachedHttpResponseGenerator;
import org.apache.http.impl.client.cache.HeapResourceFactory;
import org.apache.http.impl.client.cache.HttpCache;
import org.apache.http.impl.client.cache.Proxies;
import org.apache.http.impl.client.cache.SizeLimitedResponseReader;
import org.apache.http.impl.client.cache.Variant;
import org.apache.http.message.BasicHttpResponse;

class BasicHttpCache
implements HttpCache {
    private static final Set<String> safeRequestMethods = new HashSet<String>(Arrays.asList("HEAD", "GET", "OPTIONS", "TRACE"));
    private final CacheKeyGenerator uriExtractor;
    private final ResourceFactory resourceFactory;
    private final long maxObjectSizeBytes;
    private final CacheEntryUpdater cacheEntryUpdater;
    private final CachedHttpResponseGenerator responseGenerator;
    private final HttpCacheInvalidator cacheInvalidator;
    private final HttpCacheStorage storage;
    private final Log log = LogFactory.getLog(this.getClass());

    public BasicHttpCache(ResourceFactory resourceFactory, HttpCacheStorage httpCacheStorage, CacheConfig cacheConfig, CacheKeyGenerator cacheKeyGenerator, HttpCacheInvalidator httpCacheInvalidator) {
        this.resourceFactory = resourceFactory;
        this.uriExtractor = cacheKeyGenerator;
        this.cacheEntryUpdater = new CacheEntryUpdater(resourceFactory);
        this.maxObjectSizeBytes = cacheConfig.getMaxObjectSize();
        this.responseGenerator = new CachedHttpResponseGenerator();
        this.storage = httpCacheStorage;
        this.cacheInvalidator = httpCacheInvalidator;
    }

    public BasicHttpCache(ResourceFactory resourceFactory, HttpCacheStorage httpCacheStorage, CacheConfig cacheConfig, CacheKeyGenerator cacheKeyGenerator) {
        this(resourceFactory, httpCacheStorage, cacheConfig, cacheKeyGenerator, new CacheInvalidator(cacheKeyGenerator, httpCacheStorage));
    }

    public BasicHttpCache(ResourceFactory resourceFactory, HttpCacheStorage httpCacheStorage, CacheConfig cacheConfig) {
        this(resourceFactory, httpCacheStorage, cacheConfig, new CacheKeyGenerator());
    }

    public BasicHttpCache(CacheConfig cacheConfig) {
        this(new HeapResourceFactory(), new BasicHttpCacheStorage(cacheConfig), cacheConfig);
    }

    public BasicHttpCache() {
        this(CacheConfig.DEFAULT);
    }

    @Override
    public void flushCacheEntriesFor(HttpHost httpHost, HttpRequest httpRequest) throws IOException {
        if (!safeRequestMethods.contains(httpRequest.getRequestLine().getMethod())) {
            String string = this.uriExtractor.getURI(httpHost, httpRequest);
            this.storage.removeEntry(string);
        }
    }

    @Override
    public void flushInvalidatedCacheEntriesFor(HttpHost httpHost, HttpRequest httpRequest, HttpResponse httpResponse) {
        if (!safeRequestMethods.contains(httpRequest.getRequestLine().getMethod())) {
            this.cacheInvalidator.flushInvalidatedCacheEntries(httpHost, httpRequest, httpResponse);
        }
    }

    void storeInCache(HttpHost httpHost, HttpRequest httpRequest, HttpCacheEntry httpCacheEntry) throws IOException {
        if (httpCacheEntry.hasVariants()) {
            this.storeVariantEntry(httpHost, httpRequest, httpCacheEntry);
        } else {
            this.storeNonVariantEntry(httpHost, httpRequest, httpCacheEntry);
        }
    }

    void storeNonVariantEntry(HttpHost httpHost, HttpRequest httpRequest, HttpCacheEntry httpCacheEntry) throws IOException {
        String string = this.uriExtractor.getURI(httpHost, httpRequest);
        this.storage.putEntry(string, httpCacheEntry);
    }

    void storeVariantEntry(HttpHost httpHost, final HttpRequest httpRequest, final HttpCacheEntry httpCacheEntry) throws IOException {
        String string = this.uriExtractor.getURI(httpHost, httpRequest);
        final String string2 = this.uriExtractor.getVariantURI(httpHost, httpRequest, httpCacheEntry);
        this.storage.putEntry(string2, httpCacheEntry);
        HttpCacheUpdateCallback httpCacheUpdateCallback = new HttpCacheUpdateCallback(){

            @Override
            public HttpCacheEntry update(HttpCacheEntry httpCacheEntry2) throws IOException {
                return BasicHttpCache.this.doGetUpdatedParentEntry(httpRequest.getRequestLine().getUri(), httpCacheEntry2, httpCacheEntry, BasicHttpCache.this.uriExtractor.getVariantKey(httpRequest, httpCacheEntry), string2);
            }
        };
        try {
            this.storage.updateEntry(string, httpCacheUpdateCallback);
        }
        catch (HttpCacheUpdateException httpCacheUpdateException) {
            this.log.warn("Could not update key [" + string + "]", httpCacheUpdateException);
        }
    }

    @Override
    public void reuseVariantEntryFor(HttpHost httpHost, final HttpRequest httpRequest, Variant variant) throws IOException {
        String string = this.uriExtractor.getURI(httpHost, httpRequest);
        final HttpCacheEntry httpCacheEntry = variant.getEntry();
        final String string2 = this.uriExtractor.getVariantKey(httpRequest, httpCacheEntry);
        final String string3 = variant.getCacheKey();
        HttpCacheUpdateCallback httpCacheUpdateCallback = new HttpCacheUpdateCallback(){

            @Override
            public HttpCacheEntry update(HttpCacheEntry httpCacheEntry2) throws IOException {
                return BasicHttpCache.this.doGetUpdatedParentEntry(httpRequest.getRequestLine().getUri(), httpCacheEntry2, httpCacheEntry, string2, string3);
            }
        };
        try {
            this.storage.updateEntry(string, httpCacheUpdateCallback);
        }
        catch (HttpCacheUpdateException httpCacheUpdateException) {
            this.log.warn("Could not update key [" + string + "]", httpCacheUpdateException);
        }
    }

    boolean isIncompleteResponse(HttpResponse httpResponse, Resource resource) {
        int n;
        int n2 = httpResponse.getStatusLine().getStatusCode();
        if (n2 != 200 && n2 != 206) {
            return false;
        }
        Header header = httpResponse.getFirstHeader("Content-Length");
        if (header == null) {
            return false;
        }
        try {
            n = Integer.parseInt(header.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (resource == null) {
            return false;
        }
        return resource.length() < (long)n;
    }

    CloseableHttpResponse generateIncompleteResponseError(HttpResponse httpResponse, Resource resource) {
        Integer n = Integer.valueOf(httpResponse.getFirstHeader("Content-Length").getValue());
        BasicHttpResponse basicHttpResponse = new BasicHttpResponse(HttpVersion.HTTP_1_1, 502, "Bad Gateway");
        basicHttpResponse.setHeader("Content-Type", "text/plain;charset=UTF-8");
        String string = String.format("Received incomplete response with Content-Length %d but actual body length %d", n, resource.length());
        byte[] byArray = string.getBytes();
        basicHttpResponse.setHeader("Content-Length", Integer.toString(byArray.length));
        basicHttpResponse.setEntity(new ByteArrayEntity(byArray));
        return Proxies.enhanceResponse(basicHttpResponse);
    }

    HttpCacheEntry doGetUpdatedParentEntry(String string, HttpCacheEntry httpCacheEntry, HttpCacheEntry httpCacheEntry2, String string2, String string3) throws IOException {
        HttpCacheEntry httpCacheEntry3 = httpCacheEntry;
        if (httpCacheEntry3 == null) {
            httpCacheEntry3 = httpCacheEntry2;
        }
        Resource resource = null;
        if (httpCacheEntry3.getResource() != null) {
            resource = this.resourceFactory.copy(string, httpCacheEntry3.getResource());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(httpCacheEntry3.getVariantMap());
        hashMap.put(string2, string3);
        return new HttpCacheEntry(httpCacheEntry3.getRequestDate(), httpCacheEntry3.getResponseDate(), httpCacheEntry3.getStatusLine(), httpCacheEntry3.getAllHeaders(), resource, hashMap, httpCacheEntry3.getRequestMethod());
    }

    @Override
    public HttpCacheEntry updateCacheEntry(HttpHost httpHost, HttpRequest httpRequest, HttpCacheEntry httpCacheEntry, HttpResponse httpResponse, Date date, Date date2) throws IOException {
        HttpCacheEntry httpCacheEntry2 = this.cacheEntryUpdater.updateCacheEntry(httpRequest.getRequestLine().getUri(), httpCacheEntry, date, date2, httpResponse);
        this.storeInCache(httpHost, httpRequest, httpCacheEntry2);
        return httpCacheEntry2;
    }

    @Override
    public HttpCacheEntry updateVariantCacheEntry(HttpHost httpHost, HttpRequest httpRequest, HttpCacheEntry httpCacheEntry, HttpResponse httpResponse, Date date, Date date2, String string) throws IOException {
        HttpCacheEntry httpCacheEntry2 = this.cacheEntryUpdater.updateCacheEntry(httpRequest.getRequestLine().getUri(), httpCacheEntry, date, date2, httpResponse);
        this.storage.putEntry(string, httpCacheEntry2);
        return httpCacheEntry2;
    }

    @Override
    public HttpResponse cacheAndReturnResponse(HttpHost httpHost, HttpRequest httpRequest, HttpResponse httpResponse, Date date, Date date2) throws IOException {
        return this.cacheAndReturnResponse(httpHost, httpRequest, Proxies.enhanceResponse(httpResponse), date, date2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableHttpResponse cacheAndReturnResponse(HttpHost httpHost, HttpRequest httpRequest, CloseableHttpResponse closeableHttpResponse, Date date, Date date2) throws IOException {
        boolean bl = true;
        SizeLimitedResponseReader sizeLimitedResponseReader = this.getResponseReader(httpRequest, closeableHttpResponse);
        try {
            sizeLimitedResponseReader.readResponse();
            if (sizeLimitedResponseReader.isLimitReached()) {
                bl = false;
                CloseableHttpResponse closeableHttpResponse2 = sizeLimitedResponseReader.getReconstructedResponse();
                return closeableHttpResponse2;
            }
            Resource resource = sizeLimitedResponseReader.getResource();
            if (this.isIncompleteResponse(closeableHttpResponse, resource)) {
                CloseableHttpResponse closeableHttpResponse3 = this.generateIncompleteResponseError(closeableHttpResponse, resource);
                return closeableHttpResponse3;
            }
            HttpCacheEntry httpCacheEntry = new HttpCacheEntry(date, date2, closeableHttpResponse.getStatusLine(), closeableHttpResponse.getAllHeaders(), resource, httpRequest.getRequestLine().getMethod());
            this.storeInCache(httpHost, httpRequest, httpCacheEntry);
            CloseableHttpResponse closeableHttpResponse4 = this.responseGenerator.generateResponse(HttpRequestWrapper.wrap(httpRequest, httpHost), httpCacheEntry);
            return closeableHttpResponse4;
        }
        finally {
            if (bl) {
                closeableHttpResponse.close();
            }
        }
    }

    SizeLimitedResponseReader getResponseReader(HttpRequest httpRequest, CloseableHttpResponse closeableHttpResponse) {
        return new SizeLimitedResponseReader(this.resourceFactory, this.maxObjectSizeBytes, httpRequest, closeableHttpResponse);
    }

    @Override
    public HttpCacheEntry getCacheEntry(HttpHost httpHost, HttpRequest httpRequest) throws IOException {
        HttpCacheEntry httpCacheEntry = this.storage.getEntry(this.uriExtractor.getURI(httpHost, httpRequest));
        if (httpCacheEntry == null) {
            return null;
        }
        if (!httpCacheEntry.hasVariants()) {
            return httpCacheEntry;
        }
        String string = httpCacheEntry.getVariantMap().get(this.uriExtractor.getVariantKey(httpRequest, httpCacheEntry));
        if (string == null) {
            return null;
        }
        return this.storage.getEntry(string);
    }

    @Override
    public void flushInvalidatedCacheEntriesFor(HttpHost httpHost, HttpRequest httpRequest) throws IOException {
        this.cacheInvalidator.flushInvalidatedCacheEntries(httpHost, httpRequest);
    }

    @Override
    public Map<String, Variant> getVariantCacheEntriesWithEtags(HttpHost httpHost, HttpRequest httpRequest) throws IOException {
        HashMap<String, Variant> hashMap = new HashMap<String, Variant>();
        HttpCacheEntry httpCacheEntry = this.storage.getEntry(this.uriExtractor.getURI(httpHost, httpRequest));
        if (httpCacheEntry == null || !httpCacheEntry.hasVariants()) {
            return hashMap;
        }
        for (Map.Entry<String, String> entry : httpCacheEntry.getVariantMap().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            this.addVariantWithEtag(string, string2, hashMap);
        }
        return hashMap;
    }

    private void addVariantWithEtag(String string, String string2, Map<String, Variant> map) throws IOException {
        HttpCacheEntry httpCacheEntry = this.storage.getEntry(string2);
        if (httpCacheEntry == null) {
            return;
        }
        Header header = httpCacheEntry.getFirstHeader("ETag");
        if (header == null) {
            return;
        }
        map.put(header.getValue(), new Variant(string, string2, httpCacheEntry));
    }
}

