/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.List;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class PrefixFileFilter
extends AbstractFileFilter {
    private String[] prefixes;

    public PrefixFileFilter(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The prefix must not be null");
        }
        this.prefixes = new String[]{string};
    }

    public PrefixFileFilter(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The array of prefixes must not be null");
        }
        this.prefixes = stringArray;
    }

    public PrefixFileFilter(List list) {
        if (list == null) {
            throw new IllegalArgumentException("The list of prefixes must not be null");
        }
        this.prefixes = list.toArray(new String[list.size()]);
    }

    public boolean accept(File file) {
        String string = file.getName();
        int n = 0;
        while (n < this.prefixes.length) {
            if (string.startsWith(this.prefixes[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean accept(File file, String string) {
        int n = 0;
        while (n < this.prefixes.length) {
            if (string.startsWith(this.prefixes[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

