/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;

public abstract class Parser
implements CommandLineParser {
    private CommandLine cmd;
    private Options options;
    private List requiredOptions;

    protected abstract String[] flatten(Options var1, String[] var2, boolean var3);

    public CommandLine parse(Options options, String[] stringArray) throws ParseException {
        return this.parse(options, stringArray, false);
    }

    public CommandLine parse(Options options, String[] stringArray, boolean bl) throws ParseException {
        this.options = options;
        this.requiredOptions = this.options.getRequiredOptions();
        this.cmd = new CommandLine();
        boolean bl2 = false;
        List<String> list = Arrays.asList(this.flatten(options, stringArray, bl));
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string = listIterator.next();
            if ("--".equals(string)) {
                bl2 = true;
            } else if ("-".equals(string)) {
                if (bl) {
                    bl2 = true;
                } else {
                    this.cmd.addArg(string);
                }
            } else if (string.startsWith("-")) {
                if (bl && !this.options.hasOption(string)) {
                    bl2 = true;
                    this.cmd.addArg(string);
                } else {
                    this.processOption(string, listIterator);
                }
            } else {
                this.cmd.addArg(string);
                if (bl) {
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            while (listIterator.hasNext()) {
                String string2 = listIterator.next();
                if ("--".equals(string2)) continue;
                this.cmd.addArg(string2);
            }
        }
        this.checkRequiredOptions();
        return this.cmd;
    }

    private void checkRequiredOptions() throws MissingOptionException {
        if (this.requiredOptions.size() > 0) {
            Iterator iterator = this.requiredOptions.iterator();
            StringBuffer stringBuffer = new StringBuffer();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
            }
            throw new MissingOptionException(stringBuffer.toString());
        }
    }

    public void processArgs(Option option, ListIterator listIterator) throws ParseException {
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            if (this.options.hasOption(string)) {
                listIterator.previous();
                break;
            }
            if (option.addValue(string)) continue;
            listIterator.previous();
            break;
        }
        if (option.getValues() == null && !option.hasOptionalArg()) {
            throw new MissingArgumentException("no argument for:" + option.getOpt());
        }
    }

    private void processOption(String string, ListIterator listIterator) throws ParseException {
        Option option = null;
        boolean bl = this.options.hasOption(string);
        if (!bl) {
            throw new UnrecognizedOptionException("Unrecognized option: " + string);
        }
        option = this.options.getOption(string);
        if (option.isRequired()) {
            this.requiredOptions.remove("-" + option.getOpt());
        }
        if (this.options.getOptionGroup(option) != null) {
            OptionGroup optionGroup = this.options.getOptionGroup(option);
            if (optionGroup.isRequired()) {
                this.requiredOptions.remove(optionGroup);
            }
            optionGroup.setSelected(option);
        }
        if (option.hasArg()) {
            this.processArgs(option, listIterator);
        }
        this.cmd.addOption(option);
    }
}

