/*
 * Decompiled with CFR 0.152.
 */
package net.contentobjects.jnotify.macosx;

import de.dal33t.powerfolder.util.os.OSUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import net.contentobjects.jnotify.IJNotify;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.JNotifyListener;
import net.contentobjects.jnotify.macosx.FSEventListener;
import net.contentobjects.jnotify.macosx.JNotifyException_macosx;
import net.contentobjects.jnotify.macosx.JNotify_macosx;

public class JNotifyAdapterMacOSX
implements IJNotify {
    private Hashtable<Integer, WatchData> _id2Data;

    public JNotifyAdapterMacOSX() {
        JNotify_macosx.setNotifyListener(new FSEventListener(){

            @Override
            public void notifyChange(int n, String string, String string2, boolean bl) {
                JNotifyAdapterMacOSX.this.notifyChangeEvent(n, string, string2, bl);
            }

            @Override
            public void batchStart(int n) {
                JNotifyAdapterMacOSX.this.batchStartEvent(n);
            }

            @Override
            public void batchEnd(int n) {
                JNotifyAdapterMacOSX.this.batchEndEvent(n);
            }
        });
        this._id2Data = new Hashtable();
    }

    @Override
    public int addWatch(String string, int n, boolean bl, JNotifyListener jNotifyListener) throws JNotifyException {
        File file;
        try {
            file = new File(string).getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new JNotifyException_macosx("Could not resolve canonical path for " + string);
        }
        int n2 = JNotify_macosx.addWatch(file.getPath());
        this._id2Data.put(n2, new WatchData(n2, n, jNotifyListener, string, file, bl));
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeWatch(int n) throws JNotifyException {
        Hashtable<Integer, WatchData> hashtable = this._id2Data;
        synchronized (hashtable) {
            boolean bl;
            boolean bl2 = bl = this._id2Data.remove(n) != null;
            if (bl) {
                JNotify_macosx.removeWatch(n);
            }
            return bl;
        }
    }

    private static <T> T pollFirst(TreeSet<T> treeSet) {
        T t = treeSet.first();
        if (t != null) {
            treeSet.remove(t);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyChangeEvent(int n, String string, String string2, boolean bl) {
        Hashtable<Integer, WatchData> hashtable = this._id2Data;
        synchronized (hashtable) {
            WatchData watchData = this._id2Data.get(n);
            if (watchData != null) {
                watchData.toScan.add(new ScanJob(string2, bl));
            }
        }
    }

    void batchStartEvent(int n) {
        WatchData watchData = this._id2Data.get(n);
        if (watchData != null) {
            watchData.toScan.clear();
        }
    }

    void batchEndEvent(int n) {
        WatchData watchData = this._id2Data.get(n);
        if (watchData != null) {
            ScanJob scanJob;
            JNEvents jNEvents = new JNEvents(watchData._mask);
            while ((scanJob = watchData.toScan.poll()) != null) {
                if (!watchData.watchSubtree && !watchData.fullpath.equals(scanJob.path)) continue;
                watchData.scan(scanJob, jNEvents);
            }
            if (jNEvents.created != null && jNEvents.deleted != null && jNEvents.renamed != null) {
                Iterator<Object> iterator = jNEvents.created.entrySet().iterator();
                Iterator<Map.Entry<JNFile, TreeSet<String>>> object3 = jNEvents.deleted.entrySet().iterator();
                Object object = null;
                if (iterator.hasNext()) {
                    object = (Map.Entry)iterator.next();
                }
                Map.Entry<JNFile, TreeSet<String>> entry = null;
                if (object3.hasNext()) {
                    entry = object3.next();
                }
                while (object != null && entry != null) {
                    int n2 = ((JNFile)object.getKey()).compareTo((JNFile)entry.getKey());
                    if (n2 < 0) {
                        if (!iterator.hasNext()) break;
                        object = (Map.Entry)iterator.next();
                        continue;
                    }
                    if (n2 > 0) {
                        if (!object3.hasNext()) break;
                        entry = object3.next();
                        continue;
                    }
                    String string = (String)JNotifyAdapterMacOSX.pollFirst((TreeSet)object.getValue());
                    String string2 = JNotifyAdapterMacOSX.pollFirst(entry.getValue());
                    jNEvents.renamed.put(string2, string);
                    if (((TreeSet)object.getValue()).size() == 0) {
                        iterator.remove();
                        object = null;
                    }
                    if (entry.getValue().size() == 0) {
                        object3.remove();
                        entry = null;
                    }
                    if (object == null) {
                        if (!iterator.hasNext()) break;
                        object = (Map.Entry)iterator.next();
                    }
                    if (entry != null) continue;
                    if (!object3.hasNext()) break;
                    entry = object3.next();
                }
            }
            if ((watchData._mask & 1) != 0) {
                for (TreeSet treeSet : jNEvents.created.values()) {
                    for (Map.Entry<JNFile, TreeSet<String>> entry : treeSet) {
                        watchData._notifyListener.fileCreated(n, watchData.path, ((String)((Object)entry)).substring(watchData.fullpath.length()));
                    }
                }
            }
            if ((watchData._mask & 2) != 0) {
                for (TreeSet treeSet : jNEvents.deleted.values()) {
                    for (Map.Entry<JNFile, TreeSet<String>> entry : treeSet) {
                        watchData._notifyListener.fileDeleted(n, watchData.path, ((String)((Object)entry)).substring(watchData.fullpath.length()));
                    }
                }
            }
            if ((watchData._mask & 4) != 0) {
                for (String string : jNEvents.modified) {
                    watchData._notifyListener.fileModified(n, watchData.path, string.substring(watchData.fullpath.length()));
                }
            }
            if ((watchData._mask & 8) != 0) {
                for (Map.Entry entry : jNEvents.renamed.entrySet()) {
                    watchData._notifyListener.fileRenamed(n, watchData.path, ((String)entry.getKey()).substring(watchData.fullpath.length()), ((String)entry.getValue()).substring(watchData.fullpath.length()));
                }
            }
        }
    }

    private static class WatchData {
        int _wd;
        int _mask;
        JNotifyListener _notifyListener;
        TreeMap<JNFile, TreeSet<String>> paths;
        TreeMap<String, JNFile> jnfiles;
        LinkedList<ScanJob> toScan;
        String path;
        String fullpath;
        boolean watchSubtree;

        WatchData(int n, int n2, JNotifyListener jNotifyListener, String string, File file, boolean bl) {
            this._wd = n;
            this._mask = n2;
            this._notifyListener = jNotifyListener;
            this.path = string;
            this.fullpath = file.getPath() + "/";
            this.watchSubtree = bl;
            this.paths = new TreeMap();
            this.jnfiles = new TreeMap();
            this.scan(file, true, null);
            this.toScan = new LinkedList();
        }

        public String toString() {
            return "wd=" + this._wd;
        }

        private void scan(ScanJob scanJob, JNEvents jNEvents) {
            this.scan(new File(scanJob.path), scanJob.recursive, jNEvents);
        }

        private static TreeMap<String, TreeMap<String, JNFile>> groupByNextComponent(File file, Map<String, JNFile> map) {
            TreeMap<String, TreeMap<String, JNFile>> treeMap = new TreeMap<String, TreeMap<String, JNFile>>();
            String string = null;
            TreeMap<String, JNFile> treeMap2 = null;
            String string2 = file.getAbsolutePath() + "/";
            for (Map.Entry<String, JNFile> entry : map.entrySet()) {
                if (!entry.getKey().startsWith(string2)) continue;
                String string3 = entry.getKey().substring(string2.length());
                int n = string3.indexOf(47);
                if (n != -1) {
                    string3 = string3.substring(0, n);
                }
                if (string == null || !string.equals(string3)) {
                    string = string3;
                    treeMap2 = treeMap.get(string3);
                    if (treeMap2 == null) {
                        treeMap2 = new TreeMap();
                        treeMap.put(string3, treeMap2);
                    }
                }
                treeMap2.put(entry.getKey(), entry.getValue());
            }
            return treeMap;
        }

        private static <K, V> Map.Entry<K, V> floorEntry(TreeMap<K, V> treeMap, K k) {
            Map.Entry<K, V> entry = null;
            Comparator<K> comparator = treeMap.comparator();
            for (Map.Entry<K, V> entry2 : treeMap.entrySet()) {
                if (comparator == null ? ((Comparable)k).compareTo(entry2.getKey()) < 0 : comparator.compare(k, entry2.getKey()) < 0) break;
                entry = entry2;
            }
            return entry;
        }

        private void scan(File file, boolean bl, JNEvents jNEvents) {
            TreeSet<Object> treeSet3;
            TreeSet<String> treeSet2;
            Object object2;
            File[] fileArray = file.listFiles();
            SortedMap<String, JNFile> sortedMap = this.jnfiles.tailMap(file.getAbsolutePath());
            TreeSet<Object> treeSet22 = null;
            String string = file.getAbsolutePath() + "/";
            if (fileArray != null) {
                treeSet22 = new TreeSet<Object>();
                for (int i = 0; i < fileArray.length; ++i) {
                    object2 = fileArray[i].getAbsolutePath();
                    int n = ((String)(object2 = ((String)object2).substring(string.length()))).indexOf("/");
                    if (n >= 0) {
                        object2 = ((String)object2).substring(0, n);
                    }
                    treeSet22.add(object2);
                    try {
                        boolean treeSet5;
                        boolean entry2;
                        Object n2;
                        JNFile jNFile = new JNFile(fileArray[i]);
                        Map.Entry<Object, TreeSet<String>> entry = WatchData.floorEntry(this.paths, jNFile);
                        if (entry == null || !jNFile.equals(entry.getKey())) {
                            treeSet2 = new TreeSet();
                            this.paths.put(jNFile, treeSet2);
                        } else {
                            treeSet2 = entry.getValue();
                            n2 = (JNFile)entry.getKey();
                            if (((JNFile)n2).mtime != jNFile.mtime) {
                                ((JNFile)n2).mtime = jNFile.mtime;
                                if (jNEvents != null && jNEvents.modified != null && !fileArray[i].isDirectory()) {
                                    for (TreeSet<Object> treeSet3 : treeSet2) {
                                        jNEvents.modified.add((String)((Object)treeSet3));
                                    }
                                }
                            }
                        }
                        n2 = fileArray[i].getAbsolutePath();
                        boolean bl2 = entry2 = !treeSet2.contains(n2);
                        if (entry2) {
                            treeSet2.add((String)n2);
                            if (jNEvents != null && jNEvents.created != null) {
                                treeSet3 = jNEvents.created.get(jNFile);
                                if (treeSet3 == null) {
                                    treeSet3 = new TreeSet();
                                    jNEvents.created.put(jNFile, treeSet3);
                                }
                                treeSet3.add((String)n2);
                            }
                        }
                        if ((treeSet3 = this.jnfiles.put((String)n2, jNFile)) != null && !jNFile.equals(treeSet3)) {
                            TreeSet<String> treeSet4 = this.paths.get(treeSet3);
                            if (treeSet4 != null) {
                                if (!treeSet4.remove(n2)) {
                                    // empty if block
                                }
                                if (treeSet4.size() == 0) {
                                    this.paths.remove(treeSet3);
                                }
                            }
                            if (jNEvents != null && jNEvents.deleted != null) {
                                TreeSet<String> treeSet6 = jNEvents.deleted.get(treeSet3);
                                if (treeSet6 == null) {
                                    treeSet6 = new TreeSet();
                                    jNEvents.deleted.put((JNFile)((Object)treeSet3), treeSet6);
                                }
                                treeSet6.add((String)n2);
                            }
                        }
                        boolean bl3 = treeSet5 = entry2 || bl;
                        if (!this.watchSubtree || !treeSet5 || !fileArray[i].isDirectory()) continue;
                        this.scan(fileArray[i], treeSet5, jNEvents);
                        continue;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        continue;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            TreeMap<String, TreeMap<String, JNFile>> treeMap = WatchData.groupByNextComponent(file, sortedMap);
            object2 = null;
            String string2 = null;
            if (treeSet22 != null && (object2 = treeSet22.iterator()).hasNext()) {
                string2 = (String)object2.next();
            }
            for (Map.Entry<String, TreeMap<String, JNFile>> entry : treeMap.entrySet()) {
                treeSet2 = entry.getKey();
                if (string2 != null) {
                    int n = -1;
                    while (string2 != null && (n = ((String)((Object)treeSet2)).compareTo(string2)) > 0) {
                        if (object2.hasNext()) {
                            string2 = (String)object2.next();
                            continue;
                        }
                        string2 = null;
                    }
                    if (n == 0 && string2 != null) continue;
                }
                for (Map.Entry<String, JNFile> entry2 : entry.getValue().entrySet()) {
                    treeSet3 = this.paths.get(entry2.getValue());
                    if (treeSet3 != null) {
                        if (!treeSet3.remove(entry2.getKey())) {
                            // empty if block
                        }
                        if (treeSet3.size() == 0) {
                            this.paths.remove(entry2.getValue());
                        }
                    }
                    sortedMap.remove(entry2.getKey());
                    if (jNEvents == null || jNEvents.deleted == null) continue;
                    TreeSet<String> treeSet7 = jNEvents.deleted.get(entry2.getValue());
                    if (treeSet7 == null) {
                        treeSet7 = new TreeSet();
                        jNEvents.deleted.put(entry2.getValue(), treeSet7);
                    }
                    treeSet7.add(entry2.getKey());
                }
            }
        }
    }

    private static class ScanJob {
        String path;
        boolean recursive;

        ScanJob(String string, boolean bl) {
            this.path = string;
            this.recursive = bl;
        }

        public String toString() {
            return this.path + " " + this.recursive;
        }
    }

    private static class JNEvents {
        TreeMap<JNFile, TreeSet<String>> created;
        TreeSet<String> modified;
        TreeMap<JNFile, TreeSet<String>> deleted;
        TreeMap<String, String> renamed;

        JNEvents(int n) {
            if ((n & 4) != 0) {
                this.modified = new TreeSet();
            }
            if ((n & 0xB) != 0) {
                this.created = new TreeMap();
                this.deleted = new TreeMap();
                this.renamed = new TreeMap();
            }
        }
    }

    private static class JNFile
    implements Comparable<JNFile> {
        long mtime;
        int deviceid;
        long inode;

        JNFile(File file) throws IOException {
            this.mtime = file.lastModified();
            this.stat(file.getAbsolutePath());
        }

        private native void stat(String var1) throws IOException;

        @Override
        public int compareTo(JNFile jNFile) {
            if (jNFile.deviceid != this.deviceid) {
                return this.deviceid - jNFile.deviceid;
            }
            if (this.inode < jNFile.inode) {
                return -1;
            }
            if (this.inode == jNFile.inode) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object object) {
            if (!(object instanceof JNFile)) {
                return false;
            }
            JNFile jNFile = (JNFile)object;
            return jNFile.inode == this.inode && jNFile.deviceid == this.deviceid;
        }

        public int hashCode() {
            return (this.inode + "," + this.deviceid).hashCode();
        }

        public String toString() {
            return String.format("%08x.%016x - %d", this.deviceid, this.inode, this.mtime);
        }

        static {
            OSUtil.loadLibrary(JNotifyAdapterMacOSX.class, "jnotify");
        }
    }
}

