/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues.atomic;

import io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.AtomicReferenceArrayQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class MpscAtomicArrayQueue<E>
extends AtomicReferenceArrayQueue<E>
implements QueueProgressIndicators {
    private final AtomicLong consumerIndex = new AtomicLong();
    private final AtomicLong producerIndex = new AtomicLong();
    private volatile long headCache;

    public MpscAtomicArrayQueue(int n) {
        super(n);
    }

    @Override
    public boolean offer(E e) {
        long l;
        if (null == e) {
            throw new NullPointerException();
        }
        int n = this.mask;
        long l2 = n + 1;
        long l3 = this.lvConsumerIndexCache();
        do {
            long l4;
            if (l3 > (l4 = (l = this.lvProducerIndex()) - l2)) continue;
            long l5 = this.lvConsumerIndex();
            if (l5 <= l4) {
                return false;
            }
            this.svConsumerIndexCache(l5);
            l3 = l5;
        } while (!this.casProducerIndex(l, l + 1L));
        int n2 = this.calcElementOffset(l, n);
        this.soElement(n2, e);
        return true;
    }

    public final int weakOffer(E e) {
        long l;
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        int n = this.mask;
        long l2 = n + 1;
        long l3 = this.lvProducerIndex();
        long l4 = this.lvConsumerIndexCache();
        if (l4 <= (l = l3 - l2)) {
            long l5 = this.lvConsumerIndex();
            if (l5 <= l) {
                return 1;
            }
            this.svConsumerIndexCache(l5);
        }
        if (!this.casProducerIndex(l3, l3 + 1L)) {
            return -1;
        }
        int n2 = this.calcElementOffset(l3, n);
        this.soElement(n2, e);
        return 0;
    }

    @Override
    public E poll() {
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        long l = this.lvConsumerIndex();
        int n = this.calcElementOffset(l);
        Object e = this.lvElement(atomicReferenceArray, n);
        if (null == e) {
            if (l != this.lvProducerIndex()) {
                while ((e = this.lvElement(atomicReferenceArray, n)) == null) {
                }
            } else {
                return null;
            }
        }
        this.spElement(atomicReferenceArray, n, null);
        this.soConsumerIndex(l + 1L);
        return e;
    }

    @Override
    public E peek() {
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        long l = this.lvConsumerIndex();
        int n = this.calcElementOffset(l);
        Object e = this.lvElement(atomicReferenceArray, n);
        if (null == e) {
            if (l != this.lvProducerIndex()) {
                while ((e = this.lvElement(atomicReferenceArray, n)) == null) {
                }
            } else {
                return null;
            }
        }
        return e;
    }

    @Override
    public int size() {
        long l;
        long l2;
        long l3 = this.lvConsumerIndex();
        do {
            l2 = l3;
            l = this.lvProducerIndex();
        } while (l2 != (l3 = this.lvConsumerIndex()));
        return (int)(l - l3);
    }

    @Override
    public boolean isEmpty() {
        return this.lvConsumerIndex() == this.lvProducerIndex();
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    private long lvConsumerIndex() {
        return this.consumerIndex.get();
    }

    private long lvProducerIndex() {
        return this.producerIndex.get();
    }

    protected final long lvConsumerIndexCache() {
        return this.headCache;
    }

    protected final void svConsumerIndexCache(long l) {
        this.headCache = l;
    }

    protected final boolean casProducerIndex(long l, long l2) {
        return this.producerIndex.compareAndSet(l, l2);
    }

    protected void soConsumerIndex(long l) {
        this.consumerIndex.lazySet(l);
    }
}

