/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.PlatformDependent0;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

final class Cleaner0 {
    private static final long CLEANER_FIELD_OFFSET;
    private static final Method CLEAN_METHOD;
    private static final InternalLogger logger;

    static void freeDirectBuffer(ByteBuffer byteBuffer) {
        if (CLEANER_FIELD_OFFSET == -1L || !byteBuffer.isDirect()) {
            return;
        }
        assert (CLEAN_METHOD != null) : "CLEANER_FIELD_OFFSET != -1 implies CLEAN_METHOD != null";
        try {
            Object object = PlatformDependent0.getObject(byteBuffer, CLEANER_FIELD_OFFSET);
            if (object != null) {
                CLEAN_METHOD.invoke(object, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Cleaner0() {
    }

    static {
        logger = InternalLoggerFactory.getInstance(Cleaner0.class);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
        long l = -1L;
        Method method = null;
        if (PlatformDependent0.hasUnsafe()) {
            try {
                Field field = byteBuffer.getClass().getDeclaredField("cleaner");
                field.setAccessible(true);
                l = PlatformDependent0.objectFieldOffset(field);
                Object object = field.get(byteBuffer);
                try {
                    Runnable runnable = (Runnable)object;
                    method = Runnable.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (ClassCastException classCastException) {
                    method = object.getClass().getDeclaredMethod("clean", new Class[0]);
                }
                method.invoke(object, new Object[0]);
            }
            catch (Throwable throwable) {
                l = -1L;
                method = null;
            }
        }
        logger.debug("java.nio.ByteBuffer.cleaner(): {}", (Object)(l != -1L ? "available" : "unavailable"));
        CLEANER_FIELD_OFFSET = l;
        CLEAN_METHOD = method;
        Cleaner0.freeDirectBuffer(byteBuffer);
    }
}

