/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class PromiseNotifier<V, F extends Future<V>>
implements GenericFutureListener<F> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PromiseNotifier.class);
    private final Promise<? super V>[] promises;

    @SafeVarargs
    public PromiseNotifier(Promise<? super V> ... promiseArray) {
        ObjectUtil.checkNotNull(promiseArray, "promises");
        for (Promise<? super V> promise : promiseArray) {
            if (promise != null) continue;
            throw new IllegalArgumentException("promises contains null Promise");
        }
        this.promises = (Promise[])promiseArray.clone();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void operationComplete(F f) throws Exception {
        if (f.isSuccess()) {
            void promise;
            Object v = f.get();
            Promise<? super V>[] promiseArray = this.promises;
            int n = promiseArray.length;
            boolean bl = false;
            while (promise < n) {
                Promise promise2 = promiseArray[promise];
                if (!promise2.trySuccess(v)) {
                    logger.warn("Failed to mark a promise as success because it is done already: {}", (Object)promise2);
                }
                ++promise;
            }
        } else if (f.isCancelled()) {
            for (Promise<V> promise : this.promises) {
                if (promise.cancel(false)) continue;
                logger.warn("Failed to cancel a promise because it is done already: {}", (Object)promise);
            }
        } else {
            void var5_15;
            Throwable throwable = f.cause();
            Promise<? super V>[] promiseArray = this.promises;
            int n = promiseArray.length;
            boolean bl = false;
            while (var5_15 < n) {
                Promise<V> promise = promiseArray[var5_15];
                if (!promise.tryFailure(throwable)) {
                    logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)promise, (Object)throwable);
                }
                ++var5_15;
            }
        }
    }
}

