/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.concurrent.ScheduledFutureTask;
import io.netty.util.internal.ObjectUtil;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public abstract class AbstractScheduledEventExecutor
extends AbstractEventExecutor {
    Queue<ScheduledFutureTask<?>> scheduledTaskQueue;

    protected AbstractScheduledEventExecutor() {
    }

    protected AbstractScheduledEventExecutor(EventExecutorGroup eventExecutorGroup) {
        super(eventExecutorGroup);
    }

    protected static long nanoTime() {
        return ScheduledFutureTask.nanoTime();
    }

    Queue<ScheduledFutureTask<?>> scheduledTaskQueue() {
        if (this.scheduledTaskQueue == null) {
            this.scheduledTaskQueue = new PriorityQueue();
        }
        return this.scheduledTaskQueue;
    }

    private static boolean isNullOrEmpty(Queue<ScheduledFutureTask<?>> queue) {
        return queue == null || queue.isEmpty();
    }

    protected void cancelScheduledTasks() {
        ScheduledFutureTask[] scheduledFutureTaskArray;
        assert (this.inEventLoop());
        Queue<ScheduledFutureTask<?>> queue = this.scheduledTaskQueue;
        if (AbstractScheduledEventExecutor.isNullOrEmpty(queue)) {
            return;
        }
        for (ScheduledFutureTask scheduledFutureTask : scheduledFutureTaskArray = queue.toArray(new ScheduledFutureTask[queue.size()])) {
            scheduledFutureTask.cancelWithoutRemove(false);
        }
        queue.clear();
    }

    protected final Runnable pollScheduledTask() {
        return this.pollScheduledTask(AbstractScheduledEventExecutor.nanoTime());
    }

    protected final Runnable pollScheduledTask(long l) {
        ScheduledFutureTask<?> scheduledFutureTask;
        assert (this.inEventLoop());
        Queue<ScheduledFutureTask<?>> queue = this.scheduledTaskQueue;
        ScheduledFutureTask<?> scheduledFutureTask2 = scheduledFutureTask = queue == null ? null : queue.peek();
        if (scheduledFutureTask == null) {
            return null;
        }
        if (scheduledFutureTask.deadlineNanos() <= l) {
            queue.remove();
            return scheduledFutureTask;
        }
        return null;
    }

    protected final long nextScheduledTaskNano() {
        ScheduledFutureTask<?> scheduledFutureTask;
        Queue<ScheduledFutureTask<?>> queue = this.scheduledTaskQueue;
        ScheduledFutureTask<?> scheduledFutureTask2 = scheduledFutureTask = queue == null ? null : queue.peek();
        if (scheduledFutureTask == null) {
            return -1L;
        }
        return Math.max(0L, scheduledFutureTask.deadlineNanos() - AbstractScheduledEventExecutor.nanoTime());
    }

    final ScheduledFutureTask<?> peekScheduledTask() {
        Queue<ScheduledFutureTask<?>> queue = this.scheduledTaskQueue;
        if (queue == null) {
            return null;
        }
        return queue.peek();
    }

    protected final boolean hasScheduledTasks() {
        Queue<ScheduledFutureTask<?>> queue = this.scheduledTaskQueue;
        ScheduledFutureTask<?> scheduledFutureTask = queue == null ? null : queue.peek();
        return scheduledFutureTask != null && scheduledFutureTask.deadlineNanos() <= AbstractScheduledEventExecutor.nanoTime();
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(runnable, "command");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l < 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: >= 0)", l));
        }
        return this.schedule(new ScheduledFutureTask<Object>(this, runnable, null, ScheduledFutureTask.deadlineNanos(timeUnit.toNanos(l))));
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(callable, "callable");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l < 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: >= 0)", l));
        }
        return this.schedule(new ScheduledFutureTask<V>(this, callable, ScheduledFutureTask.deadlineNanos(timeUnit.toNanos(l))));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(runnable, "command");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", l));
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException(String.format("period: %d (expected: > 0)", l2));
        }
        return this.schedule(new ScheduledFutureTask<Object>(this, Executors.callable(runnable, null), ScheduledFutureTask.deadlineNanos(timeUnit.toNanos(l)), timeUnit.toNanos(l2)));
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(runnable, "command");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", l));
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: > 0)", l2));
        }
        return this.schedule(new ScheduledFutureTask<Object>(this, Executors.callable(runnable, null), ScheduledFutureTask.deadlineNanos(timeUnit.toNanos(l)), -timeUnit.toNanos(l2)));
    }

    <V> ScheduledFuture<V> schedule(final ScheduledFutureTask<V> scheduledFutureTask) {
        if (this.inEventLoop()) {
            this.scheduledTaskQueue().add(scheduledFutureTask);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractScheduledEventExecutor.this.scheduledTaskQueue().add(scheduledFutureTask);
                }
            });
        }
        return scheduledFutureTask;
    }

    final void removeScheduled(final ScheduledFutureTask<?> scheduledFutureTask) {
        if (this.inEventLoop()) {
            this.scheduledTaskQueue().remove(scheduledFutureTask);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractScheduledEventExecutor.this.removeScheduled(scheduledFutureTask);
                }
            });
        }
    }
}

