/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.AttributeMap;
import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class DefaultAttributeMap
implements AttributeMap {
    private static final AtomicReferenceFieldUpdater<DefaultAttributeMap, AtomicReferenceArray> updater;
    private static final int BUCKET_SIZE = 4;
    private static final int MASK = 3;
    private volatile AtomicReferenceArray<DefaultAttribute<?>> attributes;

    @Override
    public <T> Attribute<T> attr(AttributeKey<T> attributeKey) {
        DefaultAttribute<Object> defaultAttribute;
        int n;
        DefaultAttribute<Object> defaultAttribute2;
        if (attributeKey == null) {
            throw new NullPointerException("key");
        }
        AtomicReferenceArray<DefaultAttribute<Object>> atomicReferenceArray = this.attributes;
        if (atomicReferenceArray == null && !updater.compareAndSet(this, null, atomicReferenceArray = new AtomicReferenceArray(4))) {
            atomicReferenceArray = this.attributes;
        }
        if ((defaultAttribute2 = atomicReferenceArray.get(n = DefaultAttributeMap.index(attributeKey))) == null) {
            defaultAttribute2 = new DefaultAttribute();
            defaultAttribute = new DefaultAttribute<T>(defaultAttribute2, attributeKey);
            ((DefaultAttribute)defaultAttribute2).next = (DefaultAttribute)defaultAttribute;
            ((DefaultAttribute)defaultAttribute).prev = (DefaultAttribute)defaultAttribute2;
            if (atomicReferenceArray.compareAndSet(n, null, defaultAttribute2)) {
                return defaultAttribute;
            }
            defaultAttribute2 = atomicReferenceArray.get(n);
        }
        defaultAttribute = defaultAttribute2;
        synchronized (defaultAttribute) {
            DefaultAttribute defaultAttribute3 = defaultAttribute2;
            while (true) {
                DefaultAttribute defaultAttribute4;
                if ((defaultAttribute4 = defaultAttribute3.next) == null) {
                    DefaultAttribute<T> defaultAttribute5 = new DefaultAttribute<T>(defaultAttribute2, attributeKey);
                    defaultAttribute3.next = (DefaultAttribute)defaultAttribute5;
                    ((DefaultAttribute)defaultAttribute5).prev = defaultAttribute3;
                    return defaultAttribute5;
                }
                if (defaultAttribute4.key == attributeKey && !defaultAttribute4.removed) {
                    return defaultAttribute4;
                }
                defaultAttribute3 = defaultAttribute4;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean hasAttr(AttributeKey<T> attributeKey) {
        if (attributeKey == null) {
            throw new NullPointerException("key");
        }
        AtomicReferenceArray<DefaultAttribute<?>> atomicReferenceArray = this.attributes;
        if (atomicReferenceArray == null) {
            return false;
        }
        int n = DefaultAttributeMap.index(attributeKey);
        DefaultAttribute<?> defaultAttribute = atomicReferenceArray.get(n);
        if (defaultAttribute == null) {
            return false;
        }
        DefaultAttribute<?> defaultAttribute2 = defaultAttribute;
        synchronized (defaultAttribute2) {
            DefaultAttribute defaultAttribute3 = ((DefaultAttribute)defaultAttribute).next;
            while (defaultAttribute3 != null) {
                if (defaultAttribute3.key == attributeKey && !defaultAttribute3.removed) {
                    return true;
                }
                defaultAttribute3 = defaultAttribute3.next;
            }
            return false;
        }
    }

    private static int index(AttributeKey<?> attributeKey) {
        return attributeKey.id() & 3;
    }

    static {
        AtomicReferenceFieldUpdater<DefaultAttributeMap, Object> atomicReferenceFieldUpdater = PlatformDependent.newAtomicReferenceFieldUpdater(DefaultAttributeMap.class, "attributes");
        if (atomicReferenceFieldUpdater == null) {
            atomicReferenceFieldUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultAttributeMap.class, AtomicReferenceArray.class, "attributes");
        }
        updater = atomicReferenceFieldUpdater;
    }

    private static final class DefaultAttribute<T>
    extends AtomicReference<T>
    implements Attribute<T> {
        private static final long serialVersionUID = -2661411462200283011L;
        private final DefaultAttribute<?> head;
        private final AttributeKey<T> key;
        private DefaultAttribute<?> prev;
        private DefaultAttribute<?> next;
        private volatile boolean removed;

        DefaultAttribute(DefaultAttribute<?> defaultAttribute, AttributeKey<T> attributeKey) {
            this.head = defaultAttribute;
            this.key = attributeKey;
        }

        DefaultAttribute() {
            this.head = this;
            this.key = null;
        }

        @Override
        public AttributeKey<T> key() {
            return this.key;
        }

        @Override
        public T setIfAbsent(T t) {
            while (!this.compareAndSet(null, t)) {
                Object v = this.get();
                if (v == null) continue;
                return (T)v;
            }
            return null;
        }

        @Override
        public T getAndRemove() {
            this.removed = true;
            T t = this.getAndSet(null);
            this.remove0();
            return t;
        }

        @Override
        public void remove() {
            this.removed = true;
            this.set(null);
            this.remove0();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove0() {
            DefaultAttribute<?> defaultAttribute = this.head;
            synchronized (defaultAttribute) {
                assert (this.head != null);
                if (this.prev == null) {
                    return;
                }
                this.prev.next = this.next;
                if (this.next != null) {
                    this.next.prev = this.prev;
                }
                this.prev = null;
                this.next = null;
            }
        }
    }
}

