/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class AbstractReferenceCounted
implements ReferenceCounted {
    private static final AtomicIntegerFieldUpdater<AbstractReferenceCounted> refCntUpdater;
    private volatile int refCnt = 1;

    @Override
    public final int refCnt() {
        return this.refCnt;
    }

    protected final void setRefCnt(int n) {
        this.refCnt = n;
    }

    @Override
    public ReferenceCounted retain() {
        int n;
        do {
            if ((n = this.refCnt) != 0 && n != Integer.MAX_VALUE) continue;
            throw new IllegalReferenceCountException(n, 1);
        } while (!refCntUpdater.compareAndSet(this, n, n + 1));
        return this;
    }

    @Override
    public ReferenceCounted retain(int n) {
        int n2;
        int n3;
        if (n <= 0) {
            throw new IllegalArgumentException("increment: " + n + " (expected: > 0)");
        }
        do {
            if ((n3 = this.refCnt) != 0 && (n2 = n3 + n) >= 0) continue;
            throw new IllegalReferenceCountException(n3, n);
        } while (!refCntUpdater.compareAndSet(this, n3, n2));
        return this;
    }

    @Override
    public ReferenceCounted touch() {
        return this.touch(null);
    }

    @Override
    public boolean release() {
        int n;
        do {
            if ((n = this.refCnt) != 0) continue;
            throw new IllegalReferenceCountException(0, -1);
        } while (!refCntUpdater.compareAndSet(this, n, n - 1));
        if (n == 1) {
            this.deallocate();
            return true;
        }
        return false;
    }

    @Override
    public boolean release(int n) {
        int n2;
        if (n <= 0) {
            throw new IllegalArgumentException("decrement: " + n + " (expected: > 0)");
        }
        do {
            if ((n2 = this.refCnt) >= n) continue;
            throw new IllegalReferenceCountException(n2, -n);
        } while (!refCntUpdater.compareAndSet(this, n2, n2 - n));
        if (n2 == n) {
            this.deallocate();
            return true;
        }
        return false;
    }

    protected abstract void deallocate();

    static {
        AtomicIntegerFieldUpdater<AbstractReferenceCounted> atomicIntegerFieldUpdater = PlatformDependent.newAtomicIntegerFieldUpdater(AbstractReferenceCounted.class, "refCnt");
        if (atomicIntegerFieldUpdater == null) {
            atomicIntegerFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractReferenceCounted.class, "refCnt");
        }
        refCntUpdater = atomicIntegerFieldUpdater;
    }
}

