/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.rtsp;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectEncoder;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.StringUtil;

public class RtspEncoder
extends HttpObjectEncoder<HttpMessage> {
    private static final byte[] CRLF = new byte[]{13, 10};

    @Override
    public boolean acceptOutboundMessage(Object object) throws Exception {
        return super.acceptOutboundMessage(object) && (object instanceof HttpRequest || object instanceof HttpResponse);
    }

    @Override
    protected void encodeInitialLine(ByteBuf byteBuf, HttpMessage httpMessage) throws Exception {
        if (httpMessage instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpMessage;
            HttpHeaders.encodeAscii(httpRequest.method().toString(), byteBuf);
            byteBuf.writeByte(32);
            byteBuf.writeBytes(httpRequest.uri().getBytes(CharsetUtil.UTF_8));
            byteBuf.writeByte(32);
            HttpHeaders.encodeAscii(httpRequest.protocolVersion().toString(), byteBuf);
            byteBuf.writeBytes(CRLF);
        } else if (httpMessage instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpMessage;
            HttpHeaders.encodeAscii(httpResponse.protocolVersion().toString(), byteBuf);
            byteBuf.writeByte(32);
            byteBuf.writeBytes(String.valueOf(httpResponse.status().code()).getBytes(CharsetUtil.US_ASCII));
            byteBuf.writeByte(32);
            HttpHeaders.encodeAscii(String.valueOf(httpResponse.status().reasonPhrase()), byteBuf);
            byteBuf.writeBytes(CRLF);
        } else {
            throw new UnsupportedMessageTypeException("Unsupported type " + StringUtil.simpleClassName(httpMessage));
        }
    }
}

