/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2.internal.hpack;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.internal.hpack.HeaderField;
import io.netty.handler.codec.http2.internal.hpack.HpackUtil;
import io.netty.handler.codec.http2.internal.hpack.HuffmanEncoder;
import io.netty.handler.codec.http2.internal.hpack.StaticTable;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.MathUtil;
import java.util.Arrays;

public final class Encoder {
    private final boolean useIndexing;
    private final boolean forceHuffmanOn;
    private final boolean forceHuffmanOff;
    private final HeaderEntry[] headerFields;
    private final HeaderEntry head = new HeaderEntry(-1, AsciiString.EMPTY_STRING, AsciiString.EMPTY_STRING, Integer.MAX_VALUE, null);
    private final HuffmanEncoder huffmanEncoder = new HuffmanEncoder();
    private final byte hashMask;
    private int size;
    private int capacity;

    public Encoder(int n) {
        this(n, 16);
    }

    public Encoder(int n, int n2) {
        this(n, true, false, false, n2);
    }

    Encoder(int n, boolean bl, boolean bl2, boolean bl3, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.useIndexing = bl;
        this.forceHuffmanOn = bl2;
        this.forceHuffmanOff = bl3;
        this.capacity = n;
        this.headerFields = new HeaderEntry[MathUtil.findNextPositivePowerOfTwo(Math.max(2, Math.min(n2, 128)))];
        this.hashMask = (byte)(this.headerFields.length - 1);
        this.head.before = this.head.after = this.head;
    }

    public void encodeHeader(ByteBuf byteBuf, CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        if (bl) {
            int n = this.getNameIndex(charSequence);
            this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil.IndexType.NEVER, n);
            return;
        }
        if (this.capacity == 0) {
            int n = StaticTable.getIndex(charSequence, charSequence2);
            if (n == -1) {
                int n2 = StaticTable.getIndex(charSequence);
                this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil.IndexType.NONE, n2);
            } else {
                Encoder.encodeInteger(byteBuf, 128, 7, n);
            }
            return;
        }
        int n = HeaderField.sizeOf(charSequence, charSequence2);
        if (n > this.capacity) {
            int n3 = this.getNameIndex(charSequence);
            this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil.IndexType.NONE, n3);
            return;
        }
        HeaderEntry headerEntry = this.getEntry(charSequence, charSequence2);
        if (headerEntry != null) {
            int n4 = this.getIndex(headerEntry.index) + StaticTable.length;
            Encoder.encodeInteger(byteBuf, 128, 7, n4);
        } else {
            int n5 = StaticTable.getIndex(charSequence, charSequence2);
            if (n5 != -1) {
                Encoder.encodeInteger(byteBuf, 128, 7, n5);
            } else {
                int n6 = this.getNameIndex(charSequence);
                if (this.useIndexing) {
                    this.ensureCapacity(n);
                }
                HpackUtil.IndexType indexType = this.useIndexing ? HpackUtil.IndexType.INCREMENTAL : HpackUtil.IndexType.NONE;
                this.encodeLiteral(byteBuf, charSequence, charSequence2, indexType, n6);
                if (this.useIndexing) {
                    this.add(charSequence, charSequence2);
                }
            }
        }
    }

    public void setMaxHeaderTableSize(ByteBuf byteBuf, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (this.capacity == n) {
            return;
        }
        this.capacity = n;
        this.ensureCapacity(0);
        Encoder.encodeInteger(byteBuf, 32, 5, n);
    }

    public int getMaxHeaderTableSize() {
        return this.capacity;
    }

    private static void encodeInteger(ByteBuf byteBuf, int n, int n2, int n3) {
        if (n2 < 0 || n2 > 8) {
            throw new IllegalArgumentException("N: " + n2);
        }
        int n4 = 255 >>> 8 - n2;
        if (n3 >= n4) {
            byteBuf.writeByte(n | n4);
            int n5 = n3 - n4;
            while (true) {
                if ((n5 & 0xFFFFFF80) == 0) {
                    byteBuf.writeByte(n5);
                    return;
                }
                byteBuf.writeByte(n5 & 0x7F | 0x80);
                n5 >>>= 7;
            }
        }
        byteBuf.writeByte(n | n3);
    }

    private void encodeStringLiteral(ByteBuf byteBuf, CharSequence charSequence) {
        int n = this.huffmanEncoder.getEncodedLength(charSequence);
        if (n < charSequence.length() && !this.forceHuffmanOff || this.forceHuffmanOn) {
            Encoder.encodeInteger(byteBuf, 128, 7, n);
            this.huffmanEncoder.encode(byteBuf, charSequence);
        } else {
            Encoder.encodeInteger(byteBuf, 0, 7, charSequence.length());
            if (charSequence instanceof AsciiString) {
                AsciiString asciiString = (AsciiString)charSequence;
                byteBuf.writeBytes(asciiString.array(), asciiString.arrayOffset(), asciiString.length());
            } else {
                byteBuf.writeCharSequence(charSequence, CharsetUtil.ISO_8859_1);
            }
        }
    }

    private void encodeLiteral(ByteBuf byteBuf, CharSequence charSequence, CharSequence charSequence2, HpackUtil.IndexType indexType, int n) {
        int n2;
        int n3;
        switch (indexType) {
            case INCREMENTAL: {
                n3 = 64;
                n2 = 6;
                break;
            }
            case NONE: {
                n3 = 0;
                n2 = 4;
                break;
            }
            case NEVER: {
                n3 = 16;
                n2 = 4;
                break;
            }
            default: {
                throw new IllegalStateException("should not reach here");
            }
        }
        Encoder.encodeInteger(byteBuf, n3, n2, n == -1 ? 0 : n);
        if (n == -1) {
            this.encodeStringLiteral(byteBuf, charSequence);
        }
        this.encodeStringLiteral(byteBuf, charSequence2);
    }

    private int getNameIndex(CharSequence charSequence) {
        int n = StaticTable.getIndex(charSequence);
        if (n == -1 && (n = this.getIndex(charSequence)) >= 0) {
            n += StaticTable.length;
        }
        return n;
    }

    private void ensureCapacity(int n) {
        int n2;
        while (this.size + n > this.capacity && (n2 = this.length()) != 0) {
            this.remove();
        }
    }

    int length() {
        return this.size == 0 ? 0 : this.head.after.index - this.head.before.index + 1;
    }

    int size() {
        return this.size;
    }

    HeaderField getHeaderField(int n) {
        HeaderEntry headerEntry = this.head;
        while (n-- >= 0) {
            headerEntry = headerEntry.before;
        }
        return headerEntry;
    }

    private HeaderEntry getEntry(CharSequence charSequence, CharSequence charSequence2) {
        if (this.length() == 0 || charSequence == null || charSequence2 == null) {
            return null;
        }
        int n = AsciiString.hashCode(charSequence);
        int n2 = this.index(n);
        HeaderEntry headerEntry = this.headerFields[n2];
        while (headerEntry != null) {
            if (headerEntry.hash == n && (HpackUtil.equalsConstantTime(charSequence, headerEntry.name) & HpackUtil.equalsConstantTime(charSequence2, headerEntry.value)) != 0) {
                return headerEntry;
            }
            headerEntry = headerEntry.next;
        }
        return null;
    }

    private int getIndex(CharSequence charSequence) {
        if (this.length() == 0 || charSequence == null) {
            return -1;
        }
        int n = AsciiString.hashCode(charSequence);
        int n2 = this.index(n);
        HeaderEntry headerEntry = this.headerFields[n2];
        while (headerEntry != null) {
            if (headerEntry.hash == n && HpackUtil.equalsConstantTime(charSequence, headerEntry.name) != 0) {
                return this.getIndex(headerEntry.index);
            }
            headerEntry = headerEntry.next;
        }
        return -1;
    }

    private int getIndex(int n) {
        return n == -1 ? -1 : n - this.head.before.index + 1;
    }

    private void add(CharSequence charSequence, CharSequence charSequence2) {
        HeaderEntry headerEntry;
        int n = HeaderField.sizeOf(charSequence, charSequence2);
        if (n > this.capacity) {
            this.clear();
            return;
        }
        while (this.size + n > this.capacity) {
            this.remove();
        }
        int n2 = AsciiString.hashCode(charSequence);
        int n3 = this.index(n2);
        HeaderEntry headerEntry2 = this.headerFields[n3];
        this.headerFields[n3] = headerEntry = new HeaderEntry(n2, charSequence, charSequence2, this.head.before.index - 1, headerEntry2);
        headerEntry.addBefore(this.head);
        this.size += n;
    }

    private HeaderField remove() {
        HeaderEntry headerEntry;
        if (this.size == 0) {
            return null;
        }
        HeaderEntry headerEntry2 = this.head.after;
        int n = headerEntry2.hash;
        int n2 = this.index(n);
        HeaderEntry headerEntry3 = headerEntry = this.headerFields[n2];
        while (headerEntry3 != null) {
            HeaderEntry headerEntry4 = headerEntry3.next;
            if (headerEntry3 == headerEntry2) {
                if (headerEntry == headerEntry2) {
                    this.headerFields[n2] = headerEntry4;
                } else {
                    headerEntry.next = headerEntry4;
                }
                headerEntry2.remove();
                this.size -= headerEntry2.size();
                return headerEntry2;
            }
            headerEntry = headerEntry3;
            headerEntry3 = headerEntry4;
        }
        return null;
    }

    private void clear() {
        Arrays.fill(this.headerFields, null);
        this.head.before = this.head.after = this.head;
        this.size = 0;
    }

    private int index(int n) {
        return n & this.hashMask;
    }

    private static class HeaderEntry
    extends HeaderField {
        HeaderEntry before;
        HeaderEntry after;
        HeaderEntry next;
        int hash;
        int index;

        HeaderEntry(int n, CharSequence charSequence, CharSequence charSequence2, int n2, HeaderEntry headerEntry) {
            super(charSequence, charSequence2);
            this.index = n2;
            this.hash = n;
            this.next = headerEntry;
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
            this.before = null;
            this.after = null;
            this.next = null;
        }

        private void addBefore(HeaderEntry headerEntry) {
            this.after = headerEntry;
            this.before = headerEntry.before;
            this.before.after = this;
            this.after.before = this;
        }
    }
}

