/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.logging.LogLevel;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class Http2FrameLogger
extends ChannelHandlerAdapter {
    private static final int BUFFER_LENGTH_THRESHOLD = 64;
    private final InternalLogger logger;
    private final InternalLogLevel level;

    public Http2FrameLogger(LogLevel logLevel) {
        this(logLevel.toInternalLevel(), InternalLoggerFactory.getInstance(Http2FrameLogger.class));
    }

    public Http2FrameLogger(LogLevel logLevel, String string) {
        this(logLevel.toInternalLevel(), InternalLoggerFactory.getInstance(string));
    }

    public Http2FrameLogger(LogLevel logLevel, Class<?> clazz) {
        this(logLevel.toInternalLevel(), InternalLoggerFactory.getInstance(clazz));
    }

    private Http2FrameLogger(InternalLogLevel internalLogLevel, InternalLogger internalLogger) {
        this.level = ObjectUtil.checkNotNull(internalLogLevel, "level");
        this.logger = ObjectUtil.checkNotNull(internalLogger, "logger");
    }

    public void logData(Direction direction, ChannelHandlerContext channelHandlerContext, int n, ByteBuf byteBuf, int n2, boolean bl) {
        if (this.enabled()) {
            this.log(direction, "%s DATA: streamId=%d, padding=%d, endStream=%b, length=%d, bytes=%s", channelHandlerContext.channel(), n, n2, bl, byteBuf.readableBytes(), this.toString(byteBuf));
        }
    }

    public void logHeaders(Direction direction, ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, boolean bl) {
        if (this.enabled()) {
            this.log(direction, "%s HEADERS: streamId=%d, headers=%s, padding=%d, endStream=%b", channelHandlerContext.channel(), n, http2Headers, n2, bl);
        }
    }

    public void logHeaders(Direction direction, ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, short s, boolean bl, int n3, boolean bl2) {
        if (this.enabled()) {
            this.log(direction, "%s HEADERS: streamId=%d, headers=%s, streamDependency=%d, weight=%d, exclusive=%b, padding=%d, endStream=%b", channelHandlerContext.channel(), n, http2Headers, n2, s, bl, n3, bl2);
        }
    }

    public void logPriority(Direction direction, ChannelHandlerContext channelHandlerContext, int n, int n2, short s, boolean bl) {
        if (this.enabled()) {
            this.log(direction, "%s PRIORITY: streamId=%d, streamDependency=%d, weight=%d, exclusive=%b", channelHandlerContext.channel(), n, n2, s, bl);
        }
    }

    public void logRstStream(Direction direction, ChannelHandlerContext channelHandlerContext, int n, long l) {
        if (this.enabled()) {
            this.log(direction, "%s RST_STREAM: streamId=%d, errorCode=%d", channelHandlerContext.channel(), n, l);
        }
    }

    public void logSettingsAck(Direction direction, ChannelHandlerContext channelHandlerContext) {
        if (this.enabled()) {
            this.log(direction, "%s SETTINGS: ack=true", channelHandlerContext.channel());
        }
    }

    public void logSettings(Direction direction, ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) {
        if (this.enabled()) {
            this.log(direction, "%s SETTINGS: ack=false, settings=%s", channelHandlerContext.channel(), http2Settings);
        }
    }

    public void logPing(Direction direction, ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        if (this.enabled()) {
            this.log(direction, "%s PING: ack=false, length=%d, bytes=%s", channelHandlerContext.channel(), byteBuf.readableBytes(), this.toString(byteBuf));
        }
    }

    public void logPingAck(Direction direction, ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        if (this.enabled()) {
            this.log(direction, "%s PING: ack=true, length=%d, bytes=%s", channelHandlerContext.channel(), byteBuf.readableBytes(), this.toString(byteBuf));
        }
    }

    public void logPushPromise(Direction direction, ChannelHandlerContext channelHandlerContext, int n, int n2, Http2Headers http2Headers, int n3) {
        if (this.enabled()) {
            this.log(direction, "%s PUSH_PROMISE: streamId=%d, promisedStreamId=%d, headers=%s, padding=%d", channelHandlerContext.channel(), n, n2, http2Headers, n3);
        }
    }

    public void logGoAway(Direction direction, ChannelHandlerContext channelHandlerContext, int n, long l, ByteBuf byteBuf) {
        if (this.enabled()) {
            this.log(direction, "%s GO_AWAY: lastStreamId=%d, errorCode=%d, length=%d, bytes=%s", channelHandlerContext.channel(), n, l, byteBuf.readableBytes(), this.toString(byteBuf));
        }
    }

    public void logWindowsUpdate(Direction direction, ChannelHandlerContext channelHandlerContext, int n, int n2) {
        if (this.enabled()) {
            this.log(direction, "%s WINDOW_UPDATE: streamId=%d, windowSizeIncrement=%d", channelHandlerContext.channel(), n, n2);
        }
    }

    public void logUnknownFrame(Direction direction, ChannelHandlerContext channelHandlerContext, byte by, int n, Http2Flags http2Flags, ByteBuf byteBuf) {
        if (this.enabled()) {
            this.log(direction, "%s UNKNOWN: frameType=%d, streamId=%d, flags=%d, length=%d, bytes=%s", channelHandlerContext.channel(), by & 0xFF, n, http2Flags.value(), byteBuf.readableBytes(), this.toString(byteBuf));
        }
    }

    private boolean enabled() {
        return this.logger.isEnabled(this.level);
    }

    private String toString(ByteBuf byteBuf) {
        if (this.level == InternalLogLevel.TRACE || byteBuf.readableBytes() <= 64) {
            return ByteBufUtil.hexDump(byteBuf);
        }
        int n = Math.min(byteBuf.readableBytes(), 64);
        return ByteBufUtil.hexDump(byteBuf, byteBuf.readerIndex(), n) + "...";
    }

    private void log(Direction direction, String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("\n----------------").append(direction.name()).append("--------------------\n").append(String.format(string, objectArray)).append("\n------------------------------------");
        this.logger.log(this.level, stringBuilder.toString());
    }

    public static enum Direction {
        INBOUND,
        OUTBOUND;

    }
}

