/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class HttpUtil {
    @Deprecated
    static final EmptyHttpHeaders EMPTY_HEADERS = new EmptyHttpHeaders();
    private static final AsciiString CHARSET_EQUALS = AsciiString.of(HttpHeaderValues.CHARSET + "=");
    private static final AsciiString SEMICOLON = AsciiString.of(";");

    private HttpUtil() {
    }

    public static boolean isOriginForm(URI uRI) {
        return uRI.getScheme() == null && uRI.getSchemeSpecificPart() == null && uRI.getHost() == null && uRI.getAuthority() == null;
    }

    public static boolean isAsteriskForm(URI uRI) {
        return "*".equals(uRI.getPath()) && uRI.getScheme() == null && uRI.getSchemeSpecificPart() == null && uRI.getHost() == null && uRI.getAuthority() == null && uRI.getQuery() == null && uRI.getFragment() == null;
    }

    public static boolean isKeepAlive(HttpMessage httpMessage) {
        String string = httpMessage.headers().get(HttpHeaderNames.CONNECTION);
        if (string != null && HttpHeaderValues.CLOSE.contentEqualsIgnoreCase(string)) {
            return false;
        }
        if (httpMessage.protocolVersion().isKeepAliveDefault()) {
            return !HttpHeaderValues.CLOSE.contentEqualsIgnoreCase(string);
        }
        return HttpHeaderValues.KEEP_ALIVE.contentEqualsIgnoreCase(string);
    }

    public static void setKeepAlive(HttpMessage httpMessage, boolean bl) {
        HttpUtil.setKeepAlive(httpMessage.headers(), httpMessage.protocolVersion(), bl);
    }

    public static void setKeepAlive(HttpHeaders httpHeaders, HttpVersion httpVersion, boolean bl) {
        if (httpVersion.isKeepAliveDefault()) {
            if (bl) {
                httpHeaders.remove(HttpHeaderNames.CONNECTION);
            } else {
                httpHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            }
        } else if (bl) {
            httpHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        } else {
            httpHeaders.remove(HttpHeaderNames.CONNECTION);
        }
    }

    public static long getContentLength(HttpMessage httpMessage) {
        String string = httpMessage.headers().get(HttpHeaderNames.CONTENT_LENGTH);
        if (string != null) {
            return Long.parseLong(string);
        }
        long l = HttpUtil.getWebSocketContentLength(httpMessage);
        if (l >= 0L) {
            return l;
        }
        throw new NumberFormatException("header not found: " + HttpHeaderNames.CONTENT_LENGTH);
    }

    public static long getContentLength(HttpMessage httpMessage, long l) {
        String string = httpMessage.headers().get(HttpHeaderNames.CONTENT_LENGTH);
        if (string != null) {
            return Long.parseLong(string);
        }
        long l2 = HttpUtil.getWebSocketContentLength(httpMessage);
        if (l2 >= 0L) {
            return l2;
        }
        return l;
    }

    public static int getContentLength(HttpMessage httpMessage, int n) {
        return (int)Math.min(Integer.MAX_VALUE, HttpUtil.getContentLength(httpMessage, (long)n));
    }

    private static int getWebSocketContentLength(HttpMessage httpMessage) {
        HttpResponse httpResponse;
        HttpHeaders httpHeaders = httpMessage.headers();
        if (httpMessage instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpMessage;
            if (HttpMethod.GET.equals(httpRequest.method()) && httpHeaders.contains(HttpHeaderNames.SEC_WEBSOCKET_KEY1) && httpHeaders.contains(HttpHeaderNames.SEC_WEBSOCKET_KEY2)) {
                return 8;
            }
        } else if (httpMessage instanceof HttpResponse && (httpResponse = (HttpResponse)httpMessage).status().code() == 101 && httpHeaders.contains(HttpHeaderNames.SEC_WEBSOCKET_ORIGIN) && httpHeaders.contains(HttpHeaderNames.SEC_WEBSOCKET_LOCATION)) {
            return 16;
        }
        return -1;
    }

    public static void setContentLength(HttpMessage httpMessage, long l) {
        httpMessage.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)l);
    }

    public static boolean isContentLengthSet(HttpMessage httpMessage) {
        return httpMessage.headers().contains(HttpHeaderNames.CONTENT_LENGTH);
    }

    public static boolean is100ContinueExpected(HttpMessage httpMessage) {
        if (!(httpMessage instanceof HttpRequest)) {
            return false;
        }
        if (httpMessage.protocolVersion().compareTo(HttpVersion.HTTP_1_1) < 0) {
            return false;
        }
        String string = httpMessage.headers().get(HttpHeaderNames.EXPECT);
        if (string == null) {
            return false;
        }
        if (HttpHeaderValues.CONTINUE.contentEqualsIgnoreCase(string)) {
            return true;
        }
        return httpMessage.headers().contains(HttpHeaderNames.EXPECT, HttpHeaderValues.CONTINUE, true);
    }

    public static void set100ContinueExpected(HttpMessage httpMessage, boolean bl) {
        if (bl) {
            httpMessage.headers().set((CharSequence)HttpHeaderNames.EXPECT, (Object)HttpHeaderValues.CONTINUE);
        } else {
            httpMessage.headers().remove(HttpHeaderNames.EXPECT);
        }
    }

    public static boolean isTransferEncodingChunked(HttpMessage httpMessage) {
        return httpMessage.headers().contains(HttpHeaderNames.TRANSFER_ENCODING, HttpHeaderValues.CHUNKED, true);
    }

    public static void setTransferEncodingChunked(HttpMessage httpMessage, boolean bl) {
        if (bl) {
            httpMessage.headers().add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            httpMessage.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
        } else {
            List<String> list = httpMessage.headers().getAll(HttpHeaderNames.TRANSFER_ENCODING);
            if (list.isEmpty()) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>(list);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                CharSequence charSequence = (CharSequence)iterator.next();
                if (!HttpHeaderValues.CHUNKED.contentEqualsIgnoreCase(charSequence)) continue;
                iterator.remove();
            }
            if (arrayList.isEmpty()) {
                httpMessage.headers().remove(HttpHeaderNames.TRANSFER_ENCODING);
            } else {
                httpMessage.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, arrayList);
            }
        }
    }

    public static Charset getCharset(HttpMessage httpMessage) {
        return HttpUtil.getCharset(httpMessage, CharsetUtil.ISO_8859_1);
    }

    public static Charset getCharset(HttpMessage httpMessage, Charset charset) {
        CharSequence charSequence = HttpUtil.getCharsetAsString(httpMessage);
        if (charSequence != null) {
            try {
                return Charset.forName(charSequence.toString());
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                return charset;
            }
        }
        return charset;
    }

    public static CharSequence getCharsetAsString(HttpMessage httpMessage) {
        int n;
        int n2;
        String string = httpMessage.headers().get(HttpHeaderNames.CONTENT_TYPE);
        if (string != null && (n2 = AsciiString.indexOfIgnoreCaseAscii(string, CHARSET_EQUALS, 0)) != -1 && (n = n2 + CHARSET_EQUALS.length()) < string.length()) {
            return string.subSequence(n, string.length());
        }
        return null;
    }

    public static CharSequence getMimeType(HttpMessage httpMessage) {
        String string = httpMessage.headers().get(HttpHeaderNames.CONTENT_TYPE);
        if (string != null) {
            int n = AsciiString.indexOfIgnoreCaseAscii(string, SEMICOLON, 0);
            if (n != -1) {
                return string.subSequence(0, n);
            }
            return string.length() > 0 ? string : null;
        }
        return null;
    }

    static void encodeAscii0(CharSequence charSequence, ByteBuf byteBuf) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            byteBuf.writeByte(HttpUtil.c2b(charSequence.charAt(i)));
        }
    }

    private static byte c2b(char c) {
        return (byte)(c > '\u00ff' ? 63 : (byte)c);
    }
}

