/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.AsciiString;

final class HttpHeadersEncoder {
    private HttpHeadersEncoder() {
    }

    public static void encoderHeader(CharSequence charSequence, CharSequence charSequence2, ByteBuf byteBuf) throws Exception {
        int n = charSequence.length();
        int n2 = charSequence2.length();
        int n3 = n + n2 + 4;
        byteBuf.ensureWritable(n3);
        int n4 = byteBuf.writerIndex();
        HttpHeadersEncoder.writeAscii(byteBuf, n4, charSequence, n);
        n4 += n;
        byteBuf.setByte(n4++, 58);
        byteBuf.setByte(n4++, 32);
        HttpHeadersEncoder.writeAscii(byteBuf, n4, charSequence2, n2);
        n4 += n2;
        byteBuf.setByte(n4++, 13);
        byteBuf.setByte(n4++, 10);
        byteBuf.writerIndex(n4);
    }

    private static void writeAscii(ByteBuf byteBuf, int n, CharSequence charSequence, int n2) {
        if (charSequence instanceof AsciiString) {
            ByteBufUtil.copy((AsciiString)charSequence, 0, byteBuf, n, n2);
        } else {
            HttpHeadersEncoder.writeCharSequence(byteBuf, n, charSequence, n2);
        }
    }

    private static void writeCharSequence(ByteBuf byteBuf, int n, CharSequence charSequence, int n2) {
        for (int i = 0; i < n2; ++i) {
            byteBuf.setByte(n++, AsciiString.c2b(charSequence.charAt(i)));
        }
    }
}

