/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.FileRegion;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;

public abstract class AbstractNioByteChannel
extends AbstractNioChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(FileRegion.class) + ')';
    private Runnable flushTask;

    protected AbstractNioByteChannel(Channel channel, SelectableChannel selectableChannel) {
        super(channel, selectableChannel, 1);
    }

    protected abstract ChannelFuture shutdownInput();

    @Override
    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioByteUnsafe();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) throws Exception {
        boolean bl;
        block14: {
            int n = -1;
            bl = false;
            while (true) {
                int n2;
                ReferenceCounted referenceCounted;
                Object object;
                if ((object = channelOutboundBuffer.current()) == null) {
                    this.clearOpWrite();
                    return;
                }
                if (object instanceof ByteBuf) {
                    referenceCounted = (ByteBuf)object;
                    n2 = ((ByteBuf)referenceCounted).readableBytes();
                    if (n2 == 0) {
                        channelOutboundBuffer.remove();
                        continue;
                    }
                    boolean bl2 = false;
                    long l = 0L;
                    if (n == -1) {
                        n = this.config().getWriteSpinCount();
                    }
                    for (int i = n - 1; i >= 0; --i) {
                        int n3 = this.doWriteBytes((ByteBuf)referenceCounted);
                        if (n3 == 0) {
                            bl = true;
                            break;
                        }
                        l += (long)n3;
                        if (((ByteBuf)referenceCounted).isReadable()) continue;
                        bl2 = true;
                        break;
                    }
                    channelOutboundBuffer.progress(l);
                    if (bl2) {
                        channelOutboundBuffer.remove();
                        continue;
                    }
                } else {
                    if (!(object instanceof FileRegion)) break;
                    referenceCounted = (FileRegion)object;
                    int n4 = n2 = referenceCounted.transferred() >= referenceCounted.count() ? 1 : 0;
                    if (n2 == 0) {
                        long l = 0L;
                        if (n == -1) {
                            n = this.config().getWriteSpinCount();
                        }
                        for (int i = n - 1; i >= 0; --i) {
                            long l2 = this.doWriteFileRegion((FileRegion)referenceCounted);
                            if (l2 == 0L) {
                                bl = true;
                                break;
                            }
                            l += l2;
                            if (referenceCounted.transferred() < referenceCounted.count()) continue;
                            n2 = 1;
                            break;
                        }
                        channelOutboundBuffer.progress(l);
                    }
                    if (n2 != 0) {
                        channelOutboundBuffer.remove();
                        continue;
                    }
                }
                break block14;
                break;
            }
            throw new Error();
        }
        this.incompleteWrite(bl);
    }

    @Override
    protected final Object filterOutboundMessage(Object object) {
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            if (byteBuf.isDirect()) {
                return object;
            }
            return this.newDirectBuffer(byteBuf);
        }
        if (object instanceof FileRegion) {
            return object;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + EXPECTED_TYPES);
    }

    protected final void incompleteWrite(boolean bl) {
        if (bl) {
            this.setOpWrite();
        } else {
            Runnable runnable = this.flushTask;
            if (runnable == null) {
                runnable = this.flushTask = new Runnable(){

                    @Override
                    public void run() {
                        AbstractNioByteChannel.this.flush();
                    }
                };
            }
            this.eventLoop().execute(runnable);
        }
    }

    protected abstract long doWriteFileRegion(FileRegion var1) throws Exception;

    protected abstract int doReadBytes(ByteBuf var1) throws Exception;

    protected abstract int doWriteBytes(ByteBuf var1) throws Exception;

    protected final void setOpWrite() {
        SelectionKey selectionKey = this.selectionKey();
        if (!selectionKey.isValid()) {
            return;
        }
        int n = selectionKey.interestOps();
        if ((n & 4) == 0) {
            selectionKey.interestOps(n | 4);
        }
    }

    protected final void clearOpWrite() {
        SelectionKey selectionKey = this.selectionKey();
        if (!selectionKey.isValid()) {
            return;
        }
        int n = selectionKey.interestOps();
        if ((n & 4) != 0) {
            selectionKey.interestOps(n & 0xFFFFFFFB);
        }
    }

    protected class NioByteUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        protected NioByteUnsafe() {
            super(AbstractNioByteChannel.this);
        }

        private void closeOnRead(ChannelPipeline channelPipeline) {
            if (AbstractNioByteChannel.this.isOpen()) {
                if (Boolean.TRUE.equals(AbstractNioByteChannel.this.config().getOption(ChannelOption.ALLOW_HALF_CLOSURE))) {
                    AbstractNioByteChannel.this.shutdownInput();
                    SelectionKey selectionKey = AbstractNioByteChannel.this.selectionKey();
                    selectionKey.interestOps(selectionKey.interestOps() & ~AbstractNioByteChannel.this.readInterestOp);
                    channelPipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
                } else {
                    this.close(this.voidPromise());
                }
            }
        }

        private void handleReadException(ChannelPipeline channelPipeline, ByteBuf byteBuf, Throwable throwable, boolean bl, RecvByteBufAllocator.Handle handle) {
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    AbstractNioByteChannel.this.readPending = false;
                    channelPipeline.fireChannelRead(byteBuf);
                } else {
                    byteBuf.release();
                }
            }
            handle.readComplete();
            channelPipeline.fireChannelReadComplete();
            channelPipeline.fireExceptionCaught(throwable);
            if (bl || throwable instanceof IOException) {
                this.closeOnRead(channelPipeline);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void read() {
            ChannelConfig channelConfig = AbstractNioByteChannel.this.config();
            ChannelPipeline channelPipeline = AbstractNioByteChannel.this.pipeline();
            ByteBufAllocator byteBufAllocator = channelConfig.getAllocator();
            RecvByteBufAllocator.Handle handle = this.recvBufAllocHandle();
            handle.reset(channelConfig);
            ByteBuf byteBuf = null;
            boolean bl = false;
            try {
                do {
                    byteBuf = handle.allocate(byteBufAllocator);
                    handle.lastBytesRead(AbstractNioByteChannel.this.doReadBytes(byteBuf));
                    if (handle.lastBytesRead() <= 0) {
                        byteBuf.release();
                        byteBuf = null;
                        bl = handle.lastBytesRead() < 0;
                        break;
                    }
                    handle.incMessagesRead(1);
                    AbstractNioByteChannel.this.readPending = false;
                    channelPipeline.fireChannelRead(byteBuf);
                    byteBuf = null;
                } while (handle.continueReading());
                handle.readComplete();
                channelPipeline.fireChannelReadComplete();
                if (bl) {
                    this.closeOnRead(channelPipeline);
                }
            }
            catch (Throwable throwable) {
                this.handleReadException(channelPipeline, byteBuf, throwable, bl, handle);
            }
            finally {
                if (!AbstractNioByteChannel.this.readPending && !channelConfig.isAutoRead()) {
                    this.removeReadOp();
                }
            }
        }
    }
}

