/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.epoll.Native;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class IovArray
implements ChannelOutboundBuffer.MessageProcessor {
    private static final int ADDRESS_SIZE = PlatformDependent.addressSize();
    private static final int IOV_SIZE = 2 * ADDRESS_SIZE;
    private static final int CAPACITY = Native.IOV_MAX * IOV_SIZE;
    private final long memoryAddress = PlatformDependent.allocateMemory(CAPACITY);
    private int count;
    private long size;

    IovArray() {
    }

    void clear() {
        this.count = 0;
        this.size = 0L;
    }

    boolean add(ByteBuf byteBuf) {
        if (this.count == Native.IOV_MAX) {
            return false;
        }
        int n = byteBuf.readableBytes();
        if (n == 0) {
            return true;
        }
        long l = byteBuf.memoryAddress();
        int n2 = byteBuf.readerIndex();
        return this.add(l, n2, n);
    }

    private boolean add(long l, int n, int n2) {
        if (n2 == 0) {
            return true;
        }
        long l2 = this.memoryAddress(this.count++);
        long l3 = l2 + (long)ADDRESS_SIZE;
        if (Native.SSIZE_MAX - (long)n2 < this.size) {
            return false;
        }
        this.size += (long)n2;
        if (ADDRESS_SIZE == 8) {
            PlatformDependent.putLong(l2, l + (long)n);
            PlatformDependent.putLong(l3, n2);
        } else {
            assert (ADDRESS_SIZE == 4);
            PlatformDependent.putInt(l2, (int)l + n);
            PlatformDependent.putInt(l3, n2);
        }
        return true;
    }

    boolean add(CompositeByteBuf compositeByteBuf) {
        ByteBuffer[] byteBufferArray = compositeByteBuf.nioBuffers();
        if (this.count + byteBufferArray.length >= Native.IOV_MAX) {
            return false;
        }
        for (int i = 0; i < byteBufferArray.length; ++i) {
            long l;
            ByteBuffer byteBuffer = byteBufferArray[i];
            int n = byteBuffer.position();
            int n2 = byteBuffer.limit() - byteBuffer.position();
            if (n2 == 0 || this.add(l = PlatformDependent.directBufferAddress(byteBuffer), n, n2)) continue;
            return false;
        }
        return true;
    }

    long processWritten(int n, long l) {
        long l2 = this.memoryAddress(n);
        long l3 = l2 + (long)ADDRESS_SIZE;
        if (ADDRESS_SIZE == 8) {
            long l4 = PlatformDependent.getLong(l3);
            if (l4 > l) {
                long l5 = PlatformDependent.getLong(l2);
                PlatformDependent.putLong(l2, l5 + l);
                PlatformDependent.putLong(l3, l4 - l);
                return -1L;
            }
            return l4;
        }
        assert (ADDRESS_SIZE == 4);
        long l6 = PlatformDependent.getInt(l3);
        if (l6 > l) {
            int n2 = PlatformDependent.getInt(l2);
            PlatformDependent.putInt(l2, (int)((long)n2 + l));
            PlatformDependent.putInt(l3, (int)(l6 - l));
            return -1L;
        }
        return l6;
    }

    int count() {
        return this.count;
    }

    long size() {
        return this.size;
    }

    long memoryAddress(int n) {
        return this.memoryAddress + (long)(IOV_SIZE * n);
    }

    void release() {
        PlatformDependent.freeMemory(this.memoryAddress);
    }

    @Override
    public boolean processMessage(Object object) throws Exception {
        if (object instanceof ByteBuf) {
            if (object instanceof CompositeByteBuf) {
                return this.add((CompositeByteBuf)object);
            }
            return this.add((ByteBuf)object);
        }
        return false;
    }
}

