/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.embedded;

import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.embedded.EmbeddedChannelId;
import io.netty.channel.embedded.EmbeddedEventLoop;
import io.netty.channel.embedded.EmbeddedSocketAddress;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.RecyclableArrayList;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;

public class EmbeddedChannel
extends AbstractChannel {
    private static final SocketAddress LOCAL_ADDRESS = new EmbeddedSocketAddress();
    private static final SocketAddress REMOTE_ADDRESS = new EmbeddedSocketAddress();
    private static final ChannelHandler[] EMPTY_HANDLERS = new ChannelHandler[0];
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EmbeddedChannel.class);
    private static final ChannelMetadata METADATA_NO_DISCONNECT = new ChannelMetadata(false);
    private static final ChannelMetadata METADATA_DISCONNECT = new ChannelMetadata(true);
    private final EmbeddedEventLoop loop = new EmbeddedEventLoop();
    private final ChannelFutureListener recordExceptionListener = new ChannelFutureListener(){

        @Override
        public void operationComplete(ChannelFuture channelFuture) throws Exception {
            EmbeddedChannel.this.recordException(channelFuture);
        }
    };
    private final ChannelMetadata metadata;
    private final ChannelConfig config;
    private Queue<Object> inboundMessages;
    private Queue<Object> outboundMessages;
    private Throwable lastException;
    private State state;

    public EmbeddedChannel() {
        this(EMPTY_HANDLERS);
    }

    public EmbeddedChannel(ChannelId channelId) {
        this(channelId, EMPTY_HANDLERS);
    }

    public EmbeddedChannel(ChannelHandler ... channelHandlerArray) {
        this(EmbeddedChannelId.INSTANCE, channelHandlerArray);
    }

    public EmbeddedChannel(boolean bl, ChannelHandler ... channelHandlerArray) {
        this(EmbeddedChannelId.INSTANCE, bl, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, ChannelHandler ... channelHandlerArray) {
        this(channelId, false, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, boolean bl, ChannelHandler ... channelHandlerArray) {
        super(null, channelId);
        this.metadata = EmbeddedChannel.metadata(bl);
        this.config = new DefaultChannelConfig(this);
        this.setup(channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, boolean bl, ChannelConfig channelConfig, ChannelHandler ... channelHandlerArray) {
        super(null, channelId);
        this.metadata = EmbeddedChannel.metadata(bl);
        this.config = ObjectUtil.checkNotNull(channelConfig, "config");
        this.setup(channelHandlerArray);
    }

    private static ChannelMetadata metadata(boolean bl) {
        return bl ? METADATA_DISCONNECT : METADATA_NO_DISCONNECT;
    }

    private void setup(final ChannelHandler ... channelHandlerArray) {
        ObjectUtil.checkNotNull(channelHandlerArray, "handlers");
        ChannelPipeline channelPipeline = this.pipeline();
        channelPipeline.addLast(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel channel) throws Exception {
                ChannelPipeline channelPipeline = channel.pipeline();
                for (ChannelHandler channelHandler : channelHandlerArray) {
                    if (channelHandler == null) break;
                    channelPipeline.addLast(channelHandler);
                }
            }
        });
        ChannelFuture channelFuture = this.loop.register(this);
        assert (channelFuture.isDone());
    }

    @Override
    protected final DefaultChannelPipeline newChannelPipeline() {
        return new EmbeddedChannelPipeline(this);
    }

    @Override
    public ChannelMetadata metadata() {
        return this.metadata;
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return this.state != State.CLOSED;
    }

    @Override
    public boolean isActive() {
        return this.state == State.ACTIVE;
    }

    public Queue<Object> inboundMessages() {
        if (this.inboundMessages == null) {
            this.inboundMessages = new ArrayDeque<Object>();
        }
        return this.inboundMessages;
    }

    @Deprecated
    public Queue<Object> lastInboundBuffer() {
        return this.inboundMessages();
    }

    public Queue<Object> outboundMessages() {
        if (this.outboundMessages == null) {
            this.outboundMessages = new ArrayDeque<Object>();
        }
        return this.outboundMessages;
    }

    @Deprecated
    public Queue<Object> lastOutboundBuffer() {
        return this.outboundMessages();
    }

    public <T> T readInbound() {
        return (T)EmbeddedChannel.poll(this.inboundMessages);
    }

    public <T> T readOutbound() {
        return (T)EmbeddedChannel.poll(this.outboundMessages);
    }

    public boolean writeInbound(Object ... objectArray) {
        this.ensureOpen();
        if (objectArray.length == 0) {
            return EmbeddedChannel.isNotEmpty(this.inboundMessages);
        }
        ChannelPipeline channelPipeline = this.pipeline();
        for (Object object : objectArray) {
            channelPipeline.fireChannelRead(object);
        }
        channelPipeline.fireChannelReadComplete();
        this.runPendingTasks();
        this.checkException();
        return EmbeddedChannel.isNotEmpty(this.inboundMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeOutbound(Object ... objectArray) {
        this.ensureOpen();
        if (objectArray.length == 0) {
            return EmbeddedChannel.isNotEmpty(this.outboundMessages);
        }
        RecyclableArrayList recyclableArrayList = RecyclableArrayList.newInstance(objectArray.length);
        try {
            Object object;
            Object[] objectArray2 = objectArray;
            int n = objectArray2.length;
            for (int i = 0; i < n && (object = objectArray2[i]) != null; ++i) {
                recyclableArrayList.add(this.write(object));
            }
            this.runPendingTasks();
            this.flush();
            int n2 = recyclableArrayList.size();
            for (n = 0; n < n2; ++n) {
                ChannelFuture channelFuture = (ChannelFuture)recyclableArrayList.get(n);
                if (channelFuture.isDone()) {
                    this.recordException(channelFuture);
                    continue;
                }
                channelFuture.addListener(this.recordExceptionListener);
            }
            this.checkException();
            n = EmbeddedChannel.isNotEmpty(this.outboundMessages) ? 1 : 0;
            return n != 0;
        }
        finally {
            recyclableArrayList.recycle();
        }
    }

    public boolean finish() {
        return this.finish(false);
    }

    public boolean finishAndReleaseAll() {
        return this.finish(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean finish(boolean bl) {
        this.close();
        try {
            this.checkException();
            boolean bl2 = EmbeddedChannel.isNotEmpty(this.inboundMessages) || EmbeddedChannel.isNotEmpty(this.outboundMessages);
            return bl2;
        }
        finally {
            if (bl) {
                EmbeddedChannel.releaseAll(this.inboundMessages);
                EmbeddedChannel.releaseAll(this.outboundMessages);
            }
        }
    }

    public boolean releaseInbound() {
        return EmbeddedChannel.releaseAll(this.inboundMessages);
    }

    public boolean releaseOutbound() {
        return EmbeddedChannel.releaseAll(this.outboundMessages);
    }

    private static boolean releaseAll(Queue<Object> queue) {
        if (EmbeddedChannel.isNotEmpty(queue)) {
            Object object;
            while ((object = queue.poll()) != null) {
                ReferenceCountUtil.release(object);
            }
            return true;
        }
        return false;
    }

    private void finishPendingTasks(boolean bl) {
        this.runPendingTasks();
        if (bl) {
            this.loop.cancelScheduledTasks();
        }
    }

    @Override
    public final ChannelFuture close() {
        return this.close(this.newPromise());
    }

    @Override
    public final ChannelFuture disconnect() {
        return this.disconnect(this.newPromise());
    }

    @Override
    public final ChannelFuture close(ChannelPromise channelPromise) {
        this.runPendingTasks();
        ChannelFuture channelFuture = super.close(channelPromise);
        this.finishPendingTasks(true);
        return channelFuture;
    }

    @Override
    public final ChannelFuture disconnect(ChannelPromise channelPromise) {
        ChannelFuture channelFuture = super.disconnect(channelPromise);
        this.finishPendingTasks(!this.metadata.hasDisconnect());
        return channelFuture;
    }

    private static boolean isNotEmpty(Queue<Object> queue) {
        return queue != null && !queue.isEmpty();
    }

    private static Object poll(Queue<Object> queue) {
        return queue != null ? queue.poll() : null;
    }

    public void runPendingTasks() {
        try {
            this.loop.runTasks();
        }
        catch (Exception exception) {
            this.recordException(exception);
        }
        try {
            this.loop.runScheduledTasks();
        }
        catch (Exception exception) {
            this.recordException(exception);
        }
    }

    public long runScheduledPendingTasks() {
        try {
            return this.loop.runScheduledTasks();
        }
        catch (Exception exception) {
            this.recordException(exception);
            return this.loop.nextScheduledTask();
        }
    }

    private void recordException(ChannelFuture channelFuture) {
        if (!channelFuture.isSuccess()) {
            this.recordException(channelFuture.cause());
        }
    }

    private void recordException(Throwable throwable) {
        if (this.lastException == null) {
            this.lastException = throwable;
        } else {
            logger.warn("More than one exception was raised. Will report only the first one and log others.", throwable);
        }
    }

    public void checkException() {
        Throwable throwable = this.lastException;
        if (throwable == null) {
            return;
        }
        this.lastException = null;
        PlatformDependent.throwException(throwable);
    }

    protected final void ensureOpen() {
        if (!this.isOpen()) {
            this.recordException(new ClosedChannelException());
            this.checkException();
        }
    }

    @Override
    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof EmbeddedEventLoop;
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.isActive() ? LOCAL_ADDRESS : null;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.isActive() ? REMOTE_ADDRESS : null;
    }

    @Override
    protected void doRegister() throws Exception {
        this.state = State.ACTIVE;
    }

    @Override
    protected void doBind(SocketAddress socketAddress) throws Exception {
    }

    @Override
    protected void doDisconnect() throws Exception {
        if (!this.metadata.hasDisconnect()) {
            this.doClose();
        }
    }

    @Override
    protected void doClose() throws Exception {
        this.state = State.CLOSED;
    }

    @Override
    protected void doBeginRead() throws Exception {
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new DefaultUnsafe();
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) throws Exception {
        Object object;
        while ((object = channelOutboundBuffer.current()) != null) {
            ReferenceCountUtil.retain(object);
            this.outboundMessages().add(object);
            channelOutboundBuffer.remove();
        }
    }

    private final class EmbeddedChannelPipeline
    extends DefaultChannelPipeline {
        public EmbeddedChannelPipeline(EmbeddedChannel embeddedChannel2) {
            super(embeddedChannel2);
        }

        @Override
        protected void onUnhandledInboundException(Throwable throwable) {
            EmbeddedChannel.this.recordException(throwable);
        }

        @Override
        protected void onUnhandledInboundMessage(Object object) {
            EmbeddedChannel.this.inboundMessages().add(object);
        }
    }

    private class DefaultUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private DefaultUnsafe() {
        }

        @Override
        public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            this.safeSetSuccess(channelPromise);
        }
    }

    private static enum State {
        OPEN,
        ACTIVE,
        CLOSED;

    }
}

